/*
 * Decompiled with CFR 0.152.
 */
package com.urbandroid.sleep.captcha.launcher;

import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.urbandroid.sleep.captcha.CaptchaSupportException;
import com.urbandroid.sleep.captcha.domain.CaptchaInfo;
import com.urbandroid.sleep.captcha.intent.SolvedCallbackIntentCreator;
import com.urbandroid.sleep.captcha.launcher.CaptchaLauncher;

public class BaseCaptchaLauncher
implements CaptchaLauncher {
    private final Context context;
    private int difficulty = 1;
    private int mode = 1;
    private String operation = "no_operation";
    private SolvedCallbackIntentCreator solvedCallbackIntentCreator;
    private int flags = 0x30000000;

    public BaseCaptchaLauncher(@NonNull Context context) {
        this.context = context;
    }

    @Override
    public CaptchaLauncher difficulty(int difficulty) {
        this.difficulty = difficulty;
        return this;
    }

    @Override
    public CaptchaLauncher operation(String operation) {
        this.operation = operation;
        return this;
    }

    @Override
    public CaptchaLauncher solvedCallbackIntentCreator(@NonNull SolvedCallbackIntentCreator solvedCallbackIntentCreator) {
        this.solvedCallbackIntentCreator = solvedCallbackIntentCreator;
        return this;
    }

    @Override
    public CaptchaLauncher addFlags(int flags) {
        this.flags |= flags;
        return this;
    }

    @Override
    public CaptchaLauncher mode(int mode) {
        this.mode = mode;
        return this;
    }

    @Override
    public void start(@NonNull CaptchaInfo captchaInfo) {
        this.context.startActivity(this.prepareIntent(captchaInfo));
    }

    @Override
    @NonNull
    public Intent prepareIntent(@NonNull CaptchaInfo captchaInfo) {
        switch (this.mode) {
            case 3: {
                return new Intent("com.urbandroid.sleep.captcha.intent.action.CONFIG").setClassName(captchaInfo.getPackageName(), captchaInfo.getActivityName()).addFlags(0x10000000).putExtra("difficulty", this.difficulty);
            }
            case 2: {
                return new Intent("com.urbandroid.sleep.captcha.intent.action.OPEN").setClassName(captchaInfo.getPackageName(), captchaInfo.getActivityName()).addFlags(0x10000000).putExtra("difficulty", this.difficulty).putExtra("preview", true);
            }
            case 1: {
                Intent solvedCaptchaIntent = this.solvedCallbackIntentCreator == null ? new Intent("com.urbandroid.sleep.captcha.intent.action.SOLVED").putExtra("captchaInfo", (Parcelable)captchaInfo).setPackage(this.context.getPackageName()) : this.solvedCallbackIntentCreator.createSolvedIntent(this.context);
                Intent unsolvedCaptchaIntent = this.solvedCallbackIntentCreator == null ? new Intent("com.urbandroid.sleep.captcha.intent.action.SOLVED").putExtra("captchaInfo", (Parcelable)captchaInfo).setPackage(this.context.getPackageName()) : this.solvedCallbackIntentCreator.createUnsolvedIntent(this.context);
                Intent captchaAliveIntent = new Intent("com.urbandroid.sleep.ACTION_DELAY_RESUMER");
                return new Intent("com.urbandroid.sleep.captcha.intent.action.OPEN").setClassName(captchaInfo.getPackageName(), captchaInfo.getActivityName()).setFlags(this.flags).putExtra("solved", (Parcelable)solvedCaptchaIntent).putExtra("unsolved", (Parcelable)unsolvedCaptchaIntent).putExtra("alive", (Parcelable)captchaAliveIntent).putExtra("difficulty", this.difficulty).putExtra(this.operation, true);
            }
        }
        throw new CaptchaSupportException("Unknown captcha mode: " + this.mode);
    }
}

