/*
 * Decompiled with CFR 0.152.
 */
package com.urbandroid.sleep.captcha;

import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.urbandroid.sleep.captcha.CaptchaSupport;
import com.urbandroid.sleep.captcha.finder.BaseCaptchaFinder;
import com.urbandroid.sleep.captcha.finder.CaptchaFinder;
import com.urbandroid.sleep.captcha.intent.IntentExtraSetter;
import com.urbandroid.sleep.captcha.launcher.BaseCaptchaLauncher;
import com.urbandroid.sleep.captcha.launcher.CaptchaLauncher;

public class BaseCaptchaSupport
implements CaptchaSupport {
    private final Context context;
    private final Intent intent;
    private final CaptchaFinder finder;
    private final CaptchaLauncher launcher;

    protected BaseCaptchaSupport(@NonNull Context context, @NonNull Intent intent) {
        this.context = context;
        this.intent = intent;
        this.finder = new BaseCaptchaFinder(context);
        this.launcher = new BaseCaptchaLauncher(context);
    }

    @Override
    public boolean isPreviewMode() {
        return this.intent.getBooleanExtra("preview", false);
    }

    @Override
    public boolean isConfigurationMode() {
        return "com.urbandroid.sleep.captcha.intent.action.CONFIG".equals(this.intent.getAction());
    }

    @Override
    public boolean isOperationalMode() {
        return !this.isPreviewMode() && !this.isConfigurationMode();
    }

    @Override
    public int getMode() {
        if (this.isPreviewMode()) {
            return 2;
        }
        if (this.isConfigurationMode()) {
            return 3;
        }
        return 1;
    }

    @Override
    public int getDifficulty() {
        return this.intent.getIntExtra("difficulty", 1);
    }

    @Override
    public void alive() {
        if (!this.isOperationalMode()) {
            return;
        }
        this.send("alive", null);
    }

    @Override
    public void solved() {
        this.solved(null);
    }

    @Override
    public void solved(@Nullable IntentExtraSetter extraSetter) {
        this.send("solved", extraSetter);
    }

    @Override
    public void unsolved() {
        this.solved(new IntentExtraSetter(){

            @Override
            public void setExtras(@NonNull Intent intent) {
                intent.putExtra("success", false);
            }
        });
    }

    void send(String event, @Nullable IntentExtraSetter extraSetter) {
        if (this.isConfigurationMode() || this.isPreviewMode()) {
            return;
        }
        Intent callbackIntent = (Intent)this.intent.getParcelableExtra(event);
        Log.i((String)"captcha-support", (String)("calling " + event + ": " + callbackIntent));
        if (callbackIntent == null) {
            return;
        }
        switch (event) {
            case "alive": {
                this.context.startService(callbackIntent);
                break;
            }
            case "solved": {
                callbackIntent.putExtra("success", true);
                if (extraSetter != null) {
                    extraSetter.setExtras(callbackIntent);
                }
                this.context.sendBroadcast(callbackIntent);
            }
        }
    }

    @Override
    public CaptchaFinder getFinder() {
        return this.finder;
    }

    @Override
    public CaptchaLauncher getLauncher() {
        return this.launcher;
    }
}

