/*
 * Decompiled with CFR 0.152.
 */
package com.urbandroid.sleep.captcha.launcher;

import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.urbandroid.sleep.captcha.CallbackReceiver;
import com.urbandroid.sleep.captcha.RemoteCaptchaCallbackListener;
import com.urbandroid.sleep.captcha.domain.CaptchaInfo;
import com.urbandroid.sleep.captcha.launcher.CaptchaLauncher;

public class BaseCaptchaLauncher
implements CaptchaLauncher {
    private final Context context;

    public BaseCaptchaLauncher(@NonNull Context context) {
        this.context = context;
    }

    @Override
    public void startCaptcha(@NonNull CaptchaInfo captchaInfo, @Nullable RemoteCaptchaCallbackListener callbackListener) {
        this.context.startActivity(this.prepareCaptchaIntent(captchaInfo, 1, 0x10000000));
    }

    @Override
    public void startCaptcha(@NonNull CaptchaInfo captchaInfo, @Nullable RemoteCaptchaCallbackListener callbackListener, int difficulty) {
        this.context.startActivity(this.prepareCaptchaIntent(captchaInfo, difficulty, 0x10000000));
    }

    @Override
    @NonNull
    public Intent prepareCaptchaIntent(@NonNull CaptchaInfo captchaInfo, int difficulty, int flags) {
        Intent solvedCaptchaIntent = new Intent(this.context, CallbackReceiver.class).setAction("com.urbandroid.sleep.captcha.intent.action.SOLVED").putExtra("captchaInfo", (Parcelable)captchaInfo);
        Intent captchaAliveIntent = new Intent(this.context, CallbackReceiver.class).setAction("com.urbandroid.sleep.captcha.intent.action.ALIVE");
        return new Intent("com.urbandroid.sleep.captcha.intent.action.OPEN").setClassName(captchaInfo.getPackageName(), captchaInfo.getActivityName()).setFlags(flags).putExtra("solved", (Parcelable)solvedCaptchaIntent).putExtra("alive", (Parcelable)captchaAliveIntent).putExtra("difficulty", difficulty).putExtra("no_operation", true);
    }
}

