/*
 * Decompiled with CFR 0.152.
 */
package com.urbanclap.analytics_client_manager_android;

import android.content.res.Resources;
import com.urbanclap.analytics_client_manager_android.CSVProperties;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;

public class AnalyticsUtility {
    private static final String KEYWORD_TRIGGER = "trigger";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap<String, CSVProperties> parseCSVFileIntoAnalyticsEvents(Resources r, int csvFileId) {
        InputStream inputStream = null;
        ArrayList<String[]> resultList = new ArrayList<String[]>();
        try {
            String csvLine;
            inputStream = r.openRawResource(csvFileId);
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            while ((csvLine = reader.readLine()) != null) {
                String[] row = csvLine.split(",");
                resultList.add(row);
            }
        }
        catch (IOException e) {
            HashMap<String, CSVProperties> csvLine = null;
            return csvLine;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Error while closing input stream: " + e);
            }
        }
        HashMap<String, CSVProperties> csvRows = new HashMap<String, CSVProperties>();
        Object row = null;
        if (resultList.size() <= 0) {
            return null;
        }
        String[] headers = (String[])resultList.get(0);
        for (int i = 1; i < resultList.size(); ++i) {
            String[] rowAsTokens = (String[])resultList.get(i);
            CSVProperties csvProperties = new CSVProperties();
            for (int j = 0; j < headers.length && j < rowAsTokens.length; ++j) {
                if (rowAsTokens[j] == null || rowAsTokens[j].length() <= 0) continue;
                csvProperties.put(headers[j], rowAsTokens[j]);
            }
            if (!csvProperties.containsKey(KEYWORD_TRIGGER)) continue;
            String trigger = (String)csvProperties.get(KEYWORD_TRIGGER);
            csvProperties.remove(KEYWORD_TRIGGER);
            csvRows.put(trigger, csvProperties);
        }
        return csvRows;
    }
}

