/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.sms;

import com.google.common.base.Preconditions;
import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestUtils;
import com.urbanairship.api.client.ResponseParser;
import com.urbanairship.api.sms.model.CustomSmsResponseMmsPayload;
import com.urbanairship.api.sms.model.CustomSmsResponseResponse;
import com.urbanairship.api.sms.model.CustomSmsResponseSmsPayload;
import com.urbanairship.api.sms.parse.SmsObjectMapper;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.entity.ContentType;

public class CustomSmsResponseRequest
implements Request<CustomSmsResponseResponse> {
    private static final String API_CUSTOM_SMS_RESPONSE = "/api/sms/custom-response";
    private CustomSmsResponseSmsPayload smsPayload = null;
    private CustomSmsResponseMmsPayload mmsPayload = null;

    private CustomSmsResponseRequest(CustomSmsResponseSmsPayload smsPayload) {
        Preconditions.checkNotNull((Object)smsPayload, (Object)"Payload must not be null");
        this.smsPayload = smsPayload;
    }

    private CustomSmsResponseRequest(CustomSmsResponseMmsPayload mmsPayload) {
        Preconditions.checkNotNull((Object)mmsPayload, (Object)"Payload must not be null");
        this.mmsPayload = mmsPayload;
    }

    public static CustomSmsResponseRequest newRequest(CustomSmsResponseSmsPayload smsPayload) {
        return new CustomSmsResponseRequest(smsPayload);
    }

    public static CustomSmsResponseRequest newRequest(CustomSmsResponseMmsPayload mmsPayload) {
        return new CustomSmsResponseRequest(mmsPayload);
    }

    @Override
    public Request.HttpMethod getHttpMethod() {
        return Request.HttpMethod.POST;
    }

    @Override
    public String getRequestBody() {
        if (this.smsPayload != null) {
            return this.smsPayload.toJSON();
        }
        if (this.mmsPayload != null) {
            return this.mmsPayload.toJSON();
        }
        return null;
    }

    @Override
    public ContentType getContentType() {
        return ContentType.APPLICATION_JSON;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/vnd.urbanairship+json; version=3");
        return headers;
    }

    @Override
    public URI getUri(URI baseUri) throws URISyntaxException {
        return RequestUtils.resolveURI(baseUri, API_CUSTOM_SMS_RESPONSE);
    }

    @Override
    public ResponseParser<CustomSmsResponseResponse> getResponseParser() {
        return response -> (CustomSmsResponseResponse)SmsObjectMapper.getInstance().readValue(response, CustomSmsResponseResponse.class);
    }

    @Override
    public boolean bearerTokenAuthRequired() {
        return true;
    }

    @Override
    public boolean canUseBearerTokenAuth() {
        return true;
    }
}

