/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.reports.model;

import com.google.common.collect.ImmutableList;
import com.urbanairship.api.common.model.ErrorDetails;
import com.urbanairship.api.reports.model.ResponseReportResponse;
import java.util.Objects;
import java.util.Optional;

public class ResponseReport {
    private final Optional<String> next_page;
    private final Optional<ImmutableList<ResponseReportResponse>> responses;
    private final Optional<Boolean> ok;
    private final Optional<String> error;
    private final Optional<ErrorDetails> errorDetails;

    private ResponseReport(Optional<String> next_page, Optional<ImmutableList<ResponseReportResponse>> responses, Boolean ok, String error, ErrorDetails errorDetails) {
        this.next_page = next_page;
        this.responses = responses;
        this.ok = Optional.ofNullable(ok);
        this.error = Optional.ofNullable(error);
        this.errorDetails = Optional.ofNullable(errorDetails);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Optional<String> getNextPage() {
        return this.next_page;
    }

    public Optional<ImmutableList<ResponseReportResponse>> getResponses() {
        return this.responses;
    }

    public Optional<Boolean> getOk() {
        return this.ok;
    }

    public Optional<String> getError() {
        return this.error;
    }

    public Optional<ErrorDetails> getErrorDetails() {
        return this.errorDetails;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResponseReport that = (ResponseReport)o;
        return Objects.equals(this.next_page, that.next_page) && Objects.equals(this.responses, that.responses) && Objects.equals(this.ok, that.ok) && Objects.equals(this.error, that.error) && Objects.equals(this.errorDetails, that.errorDetails);
    }

    public int hashCode() {
        return Objects.hash(this.next_page, this.responses, this.ok, this.error, this.errorDetails);
    }

    public String toString() {
        return "ResponseReport{next_page=" + this.next_page + ", responses=" + this.responses + ", ok=" + this.ok + ", error=" + this.error + ", errorDetails=" + this.errorDetails + '}';
    }

    public static class Builder {
        private String next_page = null;
        private ImmutableList.Builder<ResponseReportResponse> responses = ImmutableList.builder();
        private boolean ok = true;
        private String error;
        private ErrorDetails errorDetails;

        private Builder() {
        }

        public Builder setNextPage(String next_page) {
            this.next_page = next_page;
            return this;
        }

        public Builder addResponseObject(ResponseReportResponse object) {
            this.responses.add((Object)object);
            return this;
        }

        public Builder addResponseObject(Iterable<? extends ResponseReportResponse> object) {
            this.responses.addAll(object);
            return this;
        }

        public Builder setOk(boolean value) {
            this.ok = value;
            return this;
        }

        public Builder setError(String error) {
            this.error = error;
            return this;
        }

        public Builder setErrorDetails(ErrorDetails errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        public ResponseReport build() {
            return new ResponseReport(Optional.ofNullable(this.next_page), Optional.ofNullable(this.responses.build()), this.ok, this.error, this.errorDetails);
        }
    }
}

