/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.notification.android;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.urbanairship.api.push.model.DeviceType;
import com.urbanairship.api.push.model.PushExpiry;
import com.urbanairship.api.push.model.PushModelObject;
import com.urbanairship.api.push.model.notification.DevicePayloadOverride;
import com.urbanairship.api.push.model.notification.Interactive;
import com.urbanairship.api.push.model.notification.actions.Actions;
import com.urbanairship.api.push.model.notification.android.AndroidLiveUpdate;
import com.urbanairship.api.push.model.notification.android.AndroidTemplate;
import com.urbanairship.api.push.model.notification.android.Category;
import com.urbanairship.api.push.model.notification.android.PublicNotification;
import com.urbanairship.api.push.model.notification.android.Style;
import com.urbanairship.api.push.model.notification.android.Wearable;
import java.util.Map;
import java.util.Optional;

public final class AndroidDevicePayload
extends PushModelObject
implements DevicePayloadOverride {
    private final Optional<String> alert;
    private final Optional<String> collapseKey;
    private final Optional<String> notificationChannel;
    private final Optional<String> notificationTag;
    private final Optional<PushExpiry> timeToLive;
    private final Optional<String> deliveryPriority;
    private final Optional<Boolean> delayWhileIdle;
    private final Optional<ImmutableMap<String, String>> extra;
    private final Optional<Interactive> interactive;
    private final Optional<String> title;
    private final Optional<Boolean> localOnly;
    private final Optional<Wearable> wearable;
    private final Optional<String> summary;
    private final Optional<Style> style;
    private final Optional<String> sound;
    private final Optional<String> icon;
    private final Optional<String> iconColor;
    private final Optional<Integer> priority;
    private final Optional<Category> category;
    private final Optional<Integer> visibility;
    private final Optional<PublicNotification> publicNotification;
    private final Optional<Actions> actions;
    private final Optional<AndroidTemplate> template;
    private final Optional<AndroidLiveUpdate> androidLiveUpdate;

    private AndroidDevicePayload(Builder builder) {
        this.alert = Optional.ofNullable(builder.alert);
        this.collapseKey = Optional.ofNullable(builder.collapseKey);
        this.notificationChannel = Optional.ofNullable(builder.notificationChannel);
        this.notificationTag = Optional.ofNullable(builder.notificationTag);
        this.timeToLive = Optional.ofNullable(builder.timeToLive);
        this.deliveryPriority = Optional.ofNullable(builder.deliveryPriority);
        this.delayWhileIdle = Optional.ofNullable(builder.delayWhileIdle);
        this.extra = builder.extra.build().isEmpty() ? Optional.empty() : Optional.of(builder.extra.build());
        this.interactive = Optional.ofNullable(builder.interactive);
        this.title = Optional.ofNullable(builder.title);
        this.localOnly = Optional.ofNullable(builder.localOnly);
        this.wearable = Optional.ofNullable(builder.wearable);
        this.summary = Optional.ofNullable(builder.summary);
        this.style = Optional.ofNullable(builder.style);
        this.sound = Optional.ofNullable(builder.sound);
        this.icon = Optional.ofNullable(builder.icon);
        this.iconColor = Optional.ofNullable(builder.iconColor);
        this.priority = Optional.ofNullable(builder.priority);
        this.category = Optional.ofNullable(builder.category);
        this.visibility = Optional.ofNullable(builder.visibility);
        this.publicNotification = Optional.ofNullable(builder.publicNotification);
        this.actions = Optional.ofNullable(builder.actions);
        this.template = Optional.ofNullable(builder.template);
        this.androidLiveUpdate = Optional.ofNullable(builder.androidLiveUpdate);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public DeviceType getDeviceType() {
        return DeviceType.ANDROID;
    }

    @Override
    public Optional<String> getAlert() {
        return this.alert;
    }

    public Optional<String> getCollapseKey() {
        return this.collapseKey;
    }

    public Optional<String> getNotificationChannel() {
        return this.notificationChannel;
    }

    public Optional<String> getNotificationTag() {
        return this.notificationTag;
    }

    public Optional<PushExpiry> getTimeToLive() {
        return this.timeToLive;
    }

    public Optional<String> getDeliveryPriority() {
        return this.deliveryPriority;
    }

    public Optional<Boolean> getDelayWhileIdle() {
        return this.delayWhileIdle;
    }

    public Optional<ImmutableMap<String, String>> getExtra() {
        return this.extra;
    }

    public Optional<Interactive> getInteractive() {
        return this.interactive;
    }

    public Optional<String> getTitle() {
        return this.title;
    }

    public Optional<Boolean> getLocalOnly() {
        return this.localOnly;
    }

    public Optional<Wearable> getWearable() {
        return this.wearable;
    }

    public Optional<String> getSummary() {
        return this.summary;
    }

    public Optional<Style> getStyle() {
        return this.style;
    }

    public Optional<String> getSound() {
        return this.sound;
    }

    public Optional<String> getIcon() {
        return this.icon;
    }

    public Optional<String> getIconColor() {
        return this.iconColor;
    }

    public Optional<Integer> getPriority() {
        return this.priority;
    }

    public Optional<Category> getCategory() {
        return this.category;
    }

    public Optional<Integer> getVisibility() {
        return this.visibility;
    }

    public Optional<PublicNotification> getPublicNotification() {
        return this.publicNotification;
    }

    public Optional<Actions> getActions() {
        return this.actions;
    }

    public Optional<AndroidTemplate> getTemplate() {
        return this.template;
    }

    public Optional<AndroidLiveUpdate> getAndroidLiveUpdate() {
        return this.androidLiveUpdate;
    }

    public String toString() {
        return "AndroidDevicePayload{alert=" + this.alert + ", collapseKey=" + this.collapseKey + ", notificationChannel=" + this.notificationChannel + ", notificationTag=" + this.notificationTag + ", timeToLive=" + this.timeToLive + ", delayWhileIdle=" + this.delayWhileIdle + ", deliveryPriority=" + this.deliveryPriority + ", extra=" + this.extra + ", interactive=" + this.interactive + ", title=" + this.title + ", localOnly=" + this.localOnly + ", wearable=" + this.wearable + ", summary=" + this.summary + ", style=" + this.style + ", sound=" + this.sound + ", icon=" + this.icon + ", iconColor=" + this.iconColor + ", priority=" + this.priority + ", category=" + this.category + ", visibility=" + this.visibility + ", actions=" + this.actions + ", publicNotification=" + this.publicNotification + ", template=" + this.template + ", androidLiveUpdate=" + this.androidLiveUpdate + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AndroidDevicePayload that = (AndroidDevicePayload)o;
        if (!this.alert.equals(that.alert)) {
            return false;
        }
        if (!this.category.equals(that.category)) {
            return false;
        }
        if (!this.collapseKey.equals(that.collapseKey)) {
            return false;
        }
        if (!this.notificationChannel.equals(that.notificationChannel)) {
            return false;
        }
        if (!this.notificationTag.equals(that.notificationTag)) {
            return false;
        }
        if (!this.delayWhileIdle.equals(that.delayWhileIdle)) {
            return false;
        }
        if (!this.deliveryPriority.equals(that.deliveryPriority)) {
            return false;
        }
        if (!this.extra.equals(that.extra)) {
            return false;
        }
        if (!this.interactive.equals(that.interactive)) {
            return false;
        }
        if (!this.localOnly.equals(that.localOnly)) {
            return false;
        }
        if (!this.priority.equals(that.priority)) {
            return false;
        }
        if (!this.style.equals(that.style)) {
            return false;
        }
        if (!this.sound.equals(that.sound)) {
            return false;
        }
        if (!this.icon.equals(that.icon)) {
            return false;
        }
        if (!this.iconColor.equals(that.iconColor)) {
            return false;
        }
        if (!this.summary.equals(that.summary)) {
            return false;
        }
        if (!this.timeToLive.equals(that.timeToLive)) {
            return false;
        }
        if (!this.title.equals(that.title)) {
            return false;
        }
        if (!this.visibility.equals(that.visibility)) {
            return false;
        }
        if (!this.wearable.equals(that.wearable)) {
            return false;
        }
        if (!this.publicNotification.equals(that.publicNotification)) {
            return false;
        }
        if (!this.actions.equals(that.actions)) {
            return false;
        }
        if (!this.template.equals(that.template)) {
            return false;
        }
        return this.androidLiveUpdate.equals(that.androidLiveUpdate);
    }

    public int hashCode() {
        int result = this.alert.hashCode();
        result = 31 * result + this.collapseKey.hashCode();
        result = 31 * result + this.notificationChannel.hashCode();
        result = 31 * result + this.notificationTag.hashCode();
        result = 31 * result + this.timeToLive.hashCode();
        result = 31 * result + this.delayWhileIdle.hashCode();
        result = 31 * result + this.deliveryPriority.hashCode();
        result = 31 * result + this.extra.hashCode();
        result = 31 * result + this.interactive.hashCode();
        result = 31 * result + this.title.hashCode();
        result = 31 * result + this.localOnly.hashCode();
        result = 31 * result + this.wearable.hashCode();
        result = 31 * result + this.summary.hashCode();
        result = 31 * result + this.style.hashCode();
        result = 31 * result + this.sound.hashCode();
        result = 31 * result + this.icon.hashCode();
        result = 31 * result + this.iconColor.hashCode();
        result = 31 * result + this.priority.hashCode();
        result = 31 * result + this.category.hashCode();
        result = 31 * result + this.visibility.hashCode();
        result = 31 * result + this.publicNotification.hashCode();
        result = 31 * result + this.actions.hashCode();
        result = 31 * result + this.template.hashCode();
        result = 31 * result + this.androidLiveUpdate.hashCode();
        return result;
    }

    public static class Builder {
        private String alert = null;
        private String collapseKey = null;
        private String notificationChannel = null;
        private String notificationTag = null;
        private PushExpiry timeToLive = null;
        private Boolean delayWhileIdle = null;
        private String deliveryPriority = null;
        private ImmutableMap.Builder<String, String> extra = ImmutableMap.builder();
        private Interactive interactive = null;
        private String title = null;
        private Boolean localOnly = null;
        private Wearable wearable = null;
        private String summary = null;
        private Style style = null;
        private String sound = null;
        private String icon = null;
        private String iconColor = null;
        private Integer priority = null;
        private Category category = null;
        private Integer visibility = null;
        private PublicNotification publicNotification = null;
        private Actions actions;
        private AndroidTemplate template;
        private AndroidLiveUpdate androidLiveUpdate;

        private Builder() {
        }

        public Builder setAlert(String alert) {
            this.alert = alert;
            return this;
        }

        public Builder setCollapseKey(String collapseKey) {
            this.collapseKey = collapseKey;
            return this;
        }

        public Builder setNotificationChannel(String notificationChannel) {
            this.notificationChannel = notificationChannel;
            return this;
        }

        public Builder setNotificationTag(String notificationTag) {
            this.notificationTag = notificationTag;
            return this;
        }

        public Builder setTimeToLive(PushExpiry value) {
            this.timeToLive = value;
            return this;
        }

        public Builder setDeliveryPriority(String deliveryPriority) {
            Preconditions.checkArgument((deliveryPriority.equals("high") || deliveryPriority.equals("normal") ? 1 : 0) != 0, (Object)"Delivery priority must be one of \"high\" or \"normal\".");
            this.deliveryPriority = deliveryPriority;
            return this;
        }

        public Builder setDelayWhileIdle(boolean value) {
            this.delayWhileIdle = value;
            return this;
        }

        public Builder addExtraEntry(String key, String value) {
            this.extra.put((Object)key, (Object)value);
            return this;
        }

        public Builder addAllExtraEntries(Map<String, String> entries) {
            this.extra.putAll(entries);
            return this;
        }

        public Builder setInteractive(Interactive value) {
            this.interactive = value;
            return this;
        }

        public Builder setTitle(String value) {
            this.title = value;
            return this;
        }

        public Builder setLocalOnly(Boolean value) {
            this.localOnly = value;
            return this;
        }

        public Builder setWearable(Wearable value) {
            this.wearable = value;
            return this;
        }

        public Builder setSummary(String value) {
            this.summary = value;
            return this;
        }

        public Builder setStyle(Style value) {
            this.style = value;
            return this;
        }

        public Builder setSound(String sound) {
            this.sound = sound;
            return this;
        }

        public Builder setIcon(String icon) {
            this.icon = icon;
            return this;
        }

        public Builder setIconColor(String iconColor) {
            this.iconColor = iconColor;
            return this;
        }

        public Builder setPriority(Integer value) {
            Preconditions.checkArgument((value < 3 && value > -3 ? 1 : 0) != 0, (Object)"priority must be an integer between -2 and 2");
            this.priority = value;
            return this;
        }

        public Builder setCategory(Category value) {
            this.category = value;
            return this;
        }

        public Builder setVisibility(Integer value) {
            Preconditions.checkArgument((value < 2 && value > -2 ? 1 : 0) != 0, (Object)"visibility must be an integer between -2 and 2");
            this.visibility = value;
            return this;
        }

        public Builder setPublicNotification(PublicNotification publicNotification) {
            this.publicNotification = publicNotification;
            return this;
        }

        public Builder setActions(Actions actions) {
            this.actions = actions;
            return this;
        }

        public Builder setTemplate(AndroidTemplate template) {
            this.template = template;
            return this;
        }

        public Builder setAndroidLiveUpdate(AndroidLiveUpdate androidLiveUpdate) {
            this.androidLiveUpdate = androidLiveUpdate;
            return this;
        }

        public AndroidDevicePayload build() {
            return new AndroidDevicePayload(this);
        }
    }
}

