/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.notification.adm;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.urbanairship.api.push.model.notification.adm.ADMFields;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
public class ADMTemplate {
    private final Optional<String> templateId;
    private final Optional<ADMFields> admFields;

    private ADMTemplate(Builder builder) {
        this.templateId = Optional.ofNullable(builder.templateId);
        this.admFields = Optional.ofNullable(builder.admFields);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonProperty(value="template_id")
    public Optional<String> getTemplateId() {
        return this.templateId;
    }

    @JsonProperty(value="fields")
    public Optional<ADMFields> getAdmFields() {
        return this.admFields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ADMTemplate that = (ADMTemplate)o;
        return Objects.equal(this.templateId, that.templateId) && Objects.equal(this.admFields, that.admFields);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.templateId, this.admFields});
    }

    public String toString() {
        return "ADMTemplate{templateId=" + this.templateId + ", admFields=" + this.admFields + '}';
    }

    @JsonPOJOBuilder(withPrefix="set")
    public static class Builder {
        String templateId = null;
        ADMFields admFields = null;

        @JsonProperty(value="template_id")
        public Builder setTemplateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public Builder setFields(ADMFields admFields) {
            this.admFields = admFields;
            return this;
        }

        public ADMTemplate build() {
            Preconditions.checkArgument((this.templateId == null || this.admFields == null ? 1 : 0) != 0, (Object)"templateID and fields cannot both be set.");
            return new ADMTemplate(this);
        }
    }
}

