/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model;

import com.urbanairship.api.push.model.PushExpiry;
import com.urbanairship.api.push.model.PushModelObject;
import java.util.Objects;
import java.util.Optional;

public class PushOptions
extends PushModelObject {
    private final Optional<PushExpiry> expiry;
    private final Optional<Boolean> noThrottle;
    private final Optional<Boolean> personalization;
    private final Optional<Boolean> redactPayload;
    private final Optional<Boolean> bypassHoldoutGroups;
    private final Optional<Boolean> bypassFrequencyLimits;

    private PushOptions(Builder builder) {
        this.expiry = Optional.ofNullable(builder.expiry);
        this.noThrottle = Optional.ofNullable(builder.noThrottle);
        this.personalization = Optional.ofNullable(builder.personalization);
        this.redactPayload = Optional.ofNullable(builder.redactPayload);
        this.bypassHoldoutGroups = Optional.ofNullable(builder.bypassHoldoutGroups);
        this.bypassFrequencyLimits = Optional.ofNullable(builder.bypassFrequencyLimits);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Optional<PushExpiry> getExpiry() {
        return this.expiry;
    }

    public Optional<Boolean> getNoThrottle() {
        return this.noThrottle;
    }

    public Optional<Boolean> getPersonalization() {
        return this.personalization;
    }

    public Optional<Boolean> getRedactPayload() {
        return this.redactPayload;
    }

    public Optional<Boolean> getBypassHoldoutGroups() {
        return this.bypassHoldoutGroups;
    }

    public Optional<Boolean> getBypassFrequencyLimits() {
        return this.bypassFrequencyLimits;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PushOptions that = (PushOptions)o;
        return Objects.equals(this.expiry, that.expiry) && Objects.equals(this.noThrottle, that.noThrottle) && Objects.equals(this.personalization, that.personalization) && Objects.equals(this.redactPayload, that.redactPayload) && Objects.equals(this.bypassHoldoutGroups, that.bypassHoldoutGroups) && Objects.equals(this.bypassFrequencyLimits, that.bypassFrequencyLimits);
    }

    public int hashCode() {
        return Objects.hash(this.expiry, this.noThrottle, this.personalization, this.redactPayload, this.bypassHoldoutGroups, this.bypassFrequencyLimits);
    }

    public String toString() {
        return "PushOptions{expiry=" + this.expiry + ", noThrottle=" + this.noThrottle + ", personalization=" + this.personalization + ", redactPayload=" + this.redactPayload + ", bypassHoldoutGroups=" + this.bypassHoldoutGroups + ", bypassFrequencyLimits=" + this.bypassFrequencyLimits + '}';
    }

    public static class Builder {
        private PushExpiry expiry = null;
        private Boolean noThrottle = null;
        private Boolean personalization = null;
        private Boolean redactPayload = null;
        private Boolean bypassHoldoutGroups = null;
        private Boolean bypassFrequencyLimits = null;

        private Builder() {
        }

        public Builder setExpiry(PushExpiry value) {
            this.expiry = value;
            return this;
        }

        public Builder setNoThrottle(Boolean noThrottle) {
            this.noThrottle = noThrottle;
            return this;
        }

        public Builder setPersonalization(Boolean personalization) {
            this.personalization = personalization;
            return this;
        }

        public Builder setRedactPayload(Boolean redactPayload) {
            this.redactPayload = redactPayload;
            return this;
        }

        public Builder setBypassHoldoutGroups(Boolean bypassHoldoutGroups) {
            this.bypassHoldoutGroups = bypassHoldoutGroups;
            return this;
        }

        public Builder setBypassFrequencyLimits(Boolean bypassFrequencyLimits) {
            this.bypassFrequencyLimits = bypassFrequencyLimits;
            return this;
        }

        public PushOptions build() {
            return new PushOptions(this);
        }
    }
}

