/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.urbanairship.api.push.model.OrchestrationType;
import java.util.List;
import java.util.Objects;

public class Orchestration {
    private final List<String> orchestrationChannelPriority;
    private final OrchestrationType orchestrationType;

    public Orchestration(List<String> orchestrationChannelPriority, OrchestrationType orchestrationType) {
        this.orchestrationChannelPriority = orchestrationChannelPriority;
        this.orchestrationType = orchestrationType;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public List<String> getOrchestrationChannelPriority() {
        return this.orchestrationChannelPriority;
    }

    public OrchestrationType getOrchestrationType() {
        return this.orchestrationType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Orchestration that = (Orchestration)o;
        return Objects.equals(this.orchestrationChannelPriority, that.orchestrationChannelPriority) && this.orchestrationType == that.orchestrationType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.orchestrationChannelPriority, this.orchestrationType});
    }

    public String toString() {
        return "Orchestration{orchestrationChannelPriority=" + this.orchestrationChannelPriority + ", orchestrationType=" + (Object)((Object)this.orchestrationType) + '}';
    }

    public static class Builder {
        private final ImmutableList.Builder<String> orchestrationChannelPriorityBuilder = ImmutableList.builder();
        private OrchestrationType orchestrationType = null;

        public Builder addOrchestrationChannelPriority(String orchestrationChannelPriority) {
            this.orchestrationChannelPriorityBuilder.add((Object)orchestrationChannelPriority);
            return this;
        }

        public Builder addAllOrchestrationChannelPriority(List<String> OrchestrationChannelPriority) {
            this.orchestrationChannelPriorityBuilder.addAll(OrchestrationChannelPriority);
            return this;
        }

        public Builder setOrchestrationType(OrchestrationType orchestrationType) {
            this.orchestrationType = orchestrationType;
            return this;
        }

        public Orchestration build() {
            ImmutableList orchestrationChannelPriority = this.orchestrationChannelPriorityBuilder.build();
            Preconditions.checkArgument((!this.orchestrationType.equals((Object)OrchestrationType.CHANNEL_PRIORITY) || !orchestrationChannelPriority.isEmpty() ? 1 : 0) != 0, (Object)"Channel Priority is required when type is set to channel_priority");
            return new Orchestration((List<String>)orchestrationChannelPriority, this.orchestrationType);
        }
    }
}

