/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.templates.model;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;

public class TemplateVariable {
    private final String key;
    private final Optional<String> name;
    private final Optional<String> description;
    private final String defaultValue;

    private TemplateVariable(Builder builder) {
        this.key = builder.key;
        this.name = Optional.ofNullable(builder.name);
        this.description = Optional.ofNullable(builder.description);
        this.defaultValue = builder.defaultValue;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getKey() {
        return this.key;
    }

    public Optional<String> getName() {
        return this.name;
    }

    public Optional<String> getDescription() {
        return this.description;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String toString() {
        return "TemplateVariable{key='" + this.key + ", name=" + this.name + ", description=" + this.description + ", defaultValue=" + this.defaultValue + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemplateVariable that = (TemplateVariable)o;
        if (!Objects.equals(this.defaultValue, that.defaultValue)) {
            return false;
        }
        if (!this.description.equals(that.description)) {
            return false;
        }
        if (!this.key.equals(that.key)) {
            return false;
        }
        return this.name.equals(that.name);
    }

    public int hashCode() {
        int result = this.key.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.description.hashCode();
        result = 31 * result + this.defaultValue.hashCode();
        return result;
    }

    public static class Builder {
        private String key = null;
        private String name = null;
        private String description = null;
        private String defaultValue = null;

        public Builder setKey(String key) {
            this.key = key;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public TemplateVariable build() {
            Preconditions.checkNotNull((Object)this.key, (Object)"The TemplateVariable must specify a key.");
            return new TemplateVariable(this);
        }
    }
}

