/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.nameduser.model;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.urbanairship.api.channel.model.attributes.Attribute;
import com.urbanairship.api.nameduser.model.NamedUserModelObject;
import com.urbanairship.api.nameduser.model.NamedUserUpdateChannel;
import com.urbanairship.api.nameduser.model.NamedUserUpdateChannelAction;
import java.util.List;

public class NamedUserUpdatePayload
extends NamedUserModelObject {
    private final ImmutableList<Attribute> attributes;
    private final ImmutableMap<String, List<String>> addTags;
    private final ImmutableMap<String, List<String>> setTags;
    private final ImmutableMap<String, List<String>> removeTags;
    private final ImmutableList<NamedUserUpdateChannel> channels;
    private final NamedUserUpdateChannelAction action;

    private NamedUserUpdatePayload(ImmutableList<Attribute> attributes, ImmutableMap<String, List<String>> addTags, ImmutableMap<String, List<String>> setTags, ImmutableMap<String, List<String>> removeTags, ImmutableList<NamedUserUpdateChannel> channels, NamedUserUpdateChannelAction action) {
        this.attributes = attributes;
        this.addTags = addTags;
        this.setTags = setTags;
        this.removeTags = removeTags;
        this.channels = channels;
        this.action = action;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public ImmutableList<NamedUserUpdateChannel> getChannels() {
        return this.channels;
    }

    public ImmutableList<Attribute> getAttributes() {
        return this.attributes;
    }

    public ImmutableMap<String, List<String>> getAddTags() {
        return this.addTags;
    }

    public ImmutableMap<String, List<String>> getSetTags() {
        return this.setTags;
    }

    public ImmutableMap<String, List<String>> getRemoveTags() {
        return this.removeTags;
    }

    public NamedUserUpdateChannelAction getAction() {
        return this.action;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NamedUserUpdatePayload that = (NamedUserUpdatePayload)o;
        return Objects.equal(this.attributes, that.attributes) && Objects.equal(this.channels, that.channels) && Objects.equal(this.addTags, that.addTags) && Objects.equal(this.setTags, that.setTags) && Objects.equal(this.removeTags, that.removeTags) && Objects.equal((Object)((Object)this.action), (Object)((Object)that.action));
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.attributes, this.channels, this.addTags, this.setTags, this.removeTags, this.action});
    }

    public String toString() {
        return "NamedUserUpdatePayload{attributes=" + this.attributes + "channels=" + this.channels + "addTags=" + this.addTags + "setTags=" + this.setTags + "removeTags=" + this.removeTags + "action=" + (Object)((Object)this.action) + '}';
    }

    public static class Builder {
        ImmutableList.Builder<NamedUserUpdateChannel> namedUserUpdateChannelBuilder = ImmutableList.builder();
        ImmutableList.Builder<Attribute> attributeBuilder = ImmutableList.builder();
        ImmutableMap.Builder<String, List<String>> addTagBuilder = ImmutableMap.builder();
        ImmutableMap.Builder<String, List<String>> setTagBuilder = ImmutableMap.builder();
        ImmutableMap.Builder<String, List<String>> removeTagBuilder = ImmutableMap.builder();
        NamedUserUpdateChannelAction action;

        public Builder addNamedUserUpdateChannel(NamedUserUpdateChannel namedUserUpdatechannel) {
            this.namedUserUpdateChannelBuilder.add((Object)namedUserUpdatechannel);
            return this;
        }

        public Builder addAttribute(Attribute attribute) {
            this.attributeBuilder.add((Object)attribute);
            return this;
        }

        public Builder addTags(String tagGroup, List<String> addTags) {
            this.addTagBuilder.put((Object)tagGroup, addTags);
            return this;
        }

        public Builder setTags(String tagGroup, List<String> setTags) {
            this.setTagBuilder.put((Object)tagGroup, setTags);
            return this;
        }

        public Builder removeTags(String tagGroup, List<String> removeTags) {
            this.removeTagBuilder.put((Object)tagGroup, removeTags);
            return this;
        }

        public Builder setAction(NamedUserUpdateChannelAction action) {
            this.action = action;
            return this;
        }

        public NamedUserUpdatePayload build() {
            ImmutableList updateChannels = this.namedUserUpdateChannelBuilder.build();
            ImmutableList attributes = this.attributeBuilder.build();
            ImmutableMap addTags = this.addTagBuilder.build();
            ImmutableMap setTags = this.setTagBuilder.build();
            ImmutableMap removeTags = this.removeTagBuilder.build();
            Preconditions.checkArgument((updateChannels.size() > 0 ? 1 : 0) != 0, (Object)"At least one channels must be set.");
            return new NamedUserUpdatePayload(attributes, addTags, setTags, removeTags, updateChannels, this.action);
        }
    }
}

