/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.channel.model;

import java.util.Optional;

public enum ChannelType {
    IOS("ios"),
    ADM("amazon"),
    ANDROID("android"),
    WEB("web"),
    OPEN("open"),
    EMAIL("email"),
    SMS("sms");

    private final String identifier;

    private ChannelType() {
        this(null);
    }

    private ChannelType(String identifier) {
        this.identifier = identifier;
    }

    public static Optional<ChannelType> find(String identifier) {
        for (ChannelType channelType : ChannelType.values()) {
            if (!channelType.getIdentifier().equals(identifier)) continue;
            return Optional.of(channelType);
        }
        return Optional.empty();
    }

    public String getIdentifier() {
        return this.identifier;
    }
}

