/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.staticlists.model;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.urbanairship.api.common.model.ErrorDetails;
import java.util.Objects;
import org.joda.time.DateTime;

public class StaticListView {
    private final Optional<Boolean> ok;
    private final String name;
    private final Optional<String> description;
    private final Optional<ImmutableMap<String, String>> extras;
    private final DateTime created;
    private final DateTime lastUpdated;
    private final Integer channelCount;
    private final String status;
    private final String error;
    private final ErrorDetails errorDetails;

    private StaticListView(Boolean ok, String name, String description, ImmutableMap.Builder<String, String> extras, DateTime created, DateTime lastUpdated, Integer channelCount, String status, String error, ErrorDetails errorDetails) {
        this.ok = Optional.fromNullable((Object)ok);
        this.name = name;
        this.description = Optional.fromNullable((Object)description);
        this.extras = Optional.fromNullable((Object)extras.build());
        this.created = created;
        this.lastUpdated = lastUpdated;
        this.channelCount = channelCount;
        this.status = status;
        this.error = error;
        this.errorDetails = errorDetails;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Optional<Boolean> getOk() {
        return this.ok;
    }

    public String getName() {
        return this.name;
    }

    public Optional<String> getDescription() {
        return this.description;
    }

    public Optional<ImmutableMap<String, String>> getExtras() {
        return this.extras;
    }

    public DateTime getCreated() {
        return this.created;
    }

    public DateTime getLastUpdated() {
        return this.lastUpdated;
    }

    public Integer getChannelCount() {
        return this.channelCount;
    }

    public String getStatus() {
        return this.status;
    }

    public String getError() {
        return this.error;
    }

    public ErrorDetails getErrorDetails() {
        return this.errorDetails;
    }

    public String toString() {
        return "StaticListView{ok=" + this.ok + ", name='" + this.name + '\'' + ", description=" + this.description + ", extras=" + this.extras + ", created=" + this.created + ", lastUpdated=" + this.lastUpdated + ", channelCount=" + this.channelCount + ", status='" + this.status + '\'' + ", error=" + this.error + ", errorDetails=" + this.errorDetails + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StaticListView that = (StaticListView)o;
        return Objects.equals(this.ok, that.ok) && Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && Objects.equals(this.extras, that.extras) && Objects.equals(this.created, that.created) && Objects.equals(this.lastUpdated, that.lastUpdated) && Objects.equals(this.channelCount, that.channelCount) && Objects.equals(this.status, that.status) && Objects.equals(this.error, that.error) && Objects.equals(this.errorDetails, that.errorDetails);
    }

    public int hashCode() {
        return Objects.hash(this.ok, this.name, this.description, this.extras, this.created, this.lastUpdated, this.channelCount, this.status, this.error, this.errorDetails);
    }

    public static final class Builder {
        private Boolean ok = null;
        private String name = null;
        private String description = null;
        private ImmutableMap.Builder<String, String> extras = ImmutableMap.builder();
        private DateTime created = null;
        private DateTime lastUpdated = null;
        private Integer channelCount = null;
        private String status = null;
        private String error = null;
        private ErrorDetails errorDetails = null;

        private Builder() {
        }

        public Builder setOk(Boolean ok) {
            this.ok = ok;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setCreated(DateTime created) {
            this.created = created;
            return this;
        }

        public Builder setLastUpdated(DateTime lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public Builder setChannelCount(int channelCount) {
            this.channelCount = channelCount;
            return this;
        }

        public Builder setStatus(String status) {
            this.status = status;
            return this;
        }

        public Builder addExtra(String key, String val) {
            this.extras.put((Object)key, (Object)val);
            return this;
        }

        public Builder addAllExtras(ImmutableMap<String, String> extras) {
            if (!extras.isEmpty()) {
                this.extras.putAll(extras);
            }
            return this;
        }

        public Builder setError(String error) {
            this.error = error;
            return this;
        }

        public Builder setErrorDetails(ErrorDetails errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        public StaticListView build() {
            return new StaticListView(this.ok, this.name, this.description, this.extras, this.created, this.lastUpdated, this.channelCount, this.status, this.error, this.errorDetails);
        }
    }
}

