/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.sms;

import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestUtils;
import com.urbanairship.api.client.ResponseParser;
import com.urbanairship.api.sms.parse.SmsObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.entity.ContentType;

public class KeywordInteractionRequest
implements Request<String> {
    private static final String API_SMS = "/api/sms/";
    private final List<String> senderIds = new ArrayList<String>();
    private String keyword;
    private final String path;
    private ObjectNode payloadNode = JsonNodeFactory.instance.objectNode();

    private KeywordInteractionRequest(String path) {
        this.path = path;
    }

    public static KeywordInteractionRequest newRequest(String msisdn) {
        return new KeywordInteractionRequest(API_SMS + msisdn + "/keywords");
    }

    public KeywordInteractionRequest addKeyword(String keyword) {
        this.keyword = keyword;
        return this;
    }

    public KeywordInteractionRequest addSenderId(String senderId) {
        this.senderIds.add(senderId);
        return this;
    }

    public KeywordInteractionRequest addAllSenderIds(List<String> senderId) {
        this.senderIds.addAll(senderId);
        return this;
    }

    @Override
    public Request.HttpMethod getHttpMethod() {
        return Request.HttpMethod.POST;
    }

    @Override
    public String getRequestBody() {
        this.payloadNode.put("keyword", this.keyword);
        this.payloadNode.putPOJO("sender_ids", this.senderIds);
        try {
            return SmsObjectMapper.getInstance().writeValueAsString((Object)this.payloadNode);
        }
        catch (Exception ex) {
            return "{ \"exception\" : \"" + ex.getClass().getName() + "\", \"message\" : \"" + ex.getMessage() + "\" }";
        }
    }

    @Override
    public ContentType getContentType() {
        return ContentType.APPLICATION_JSON;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/vnd.urbanairship+json; version=3");
        return headers;
    }

    @Override
    public URI getUri(URI baseUri) throws URISyntaxException {
        return RequestUtils.resolveURI(baseUri, this.path);
    }

    @Override
    public ResponseParser<String> getResponseParser() {
        return new ResponseParser<String>(){

            @Override
            public String parse(String response) throws IOException {
                return response;
            }
        };
    }

    @Override
    public boolean bearerTokenAuthRequired() {
        return false;
    }

    @Override
    public boolean canUseBearerTokenAuth() {
        return true;
    }
}

