/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.reports.model;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.urbanairship.api.common.model.ErrorDetails;
import com.urbanairship.api.reports.model.PushInfoResponse;

public class PushListingResponse {
    private final Optional<String> nextPage;
    private final Optional<ImmutableList<PushInfoResponse>> pushInfoObjects;
    private final Optional<Boolean> ok;
    private final Optional<String> error;
    private final Optional<ErrorDetails> errorDetails;

    private PushListingResponse() {
        this(null, null, null, null, null);
    }

    private PushListingResponse(String nextPage, Optional<ImmutableList<PushInfoResponse>> pushInfoObjects, Boolean ok, String error, ErrorDetails errorDetails) {
        this.nextPage = Optional.fromNullable((Object)nextPage);
        this.pushInfoObjects = pushInfoObjects;
        this.ok = Optional.fromNullable((Object)ok);
        this.error = Optional.fromNullable((Object)error);
        this.errorDetails = Optional.fromNullable((Object)errorDetails);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Optional<String> getNextPage() {
        return this.nextPage;
    }

    public Optional<ImmutableList<PushInfoResponse>> getPushInfoList() {
        return this.pushInfoObjects;
    }

    public Optional<Boolean> getOk() {
        return this.ok;
    }

    public Optional<String> getError() {
        return this.error;
    }

    public Optional<ErrorDetails> getErrorDetails() {
        return this.errorDetails;
    }

    public String toString() {
        return "PushInfoResponse{nextPage='" + this.nextPage + '\'' + ", pushInfoObjects=" + this.pushInfoObjects + ", ok=" + this.ok + ", error=" + this.error + ", errorDetails=" + this.errorDetails + '}';
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.nextPage, this.pushInfoObjects, this.ok, this.error, this.errorDetails});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PushListingResponse other = (PushListingResponse)obj;
        return Objects.equal(this.nextPage, other.nextPage) && Objects.equal(this.pushInfoObjects, other.pushInfoObjects) && Objects.equal(this.ok, other.ok) && Objects.equal(this.error, other.error) && Objects.equal(this.errorDetails, other.errorDetails);
    }

    public static class Builder {
        private String nextPage = null;
        private ImmutableList.Builder<PushInfoResponse> pushInfoObjects = ImmutableList.builder();
        private boolean ok = true;
        private String error;
        private ErrorDetails errorDetails;

        private Builder() {
        }

        public Builder setNextPage(String value) {
            this.nextPage = value;
            return this;
        }

        public Builder addPushInfoObject(PushInfoResponse value) {
            this.pushInfoObjects.add((Object)value);
            return this;
        }

        public Builder addPushInfoObjects(Iterable<? extends PushInfoResponse> value) {
            this.pushInfoObjects.addAll(value);
            return this;
        }

        public Builder setOk(boolean value) {
            this.ok = value;
            return this;
        }

        public Builder setError(String error) {
            this.error = error;
            return this;
        }

        public Builder setErrorDetails(ErrorDetails errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        public PushListingResponse build() {
            return new PushListingResponse(this.nextPage, Optional.fromNullable((Object)this.pushInfoObjects.build()), this.ok, this.error, this.errorDetails);
        }
    }
}

