/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.reports.model;

import com.google.common.collect.ImmutableList;
import com.urbanairship.api.common.model.ErrorDetails;
import com.urbanairship.api.reports.model.DevicesReportResponse;
import java.util.Objects;
import java.util.Optional;

public class DevicesReport {
    private final Optional<String> dateClosed;
    private final Optional<String> dateComputed;
    private final Optional<Integer> totalUniqueDevices;
    private final Optional<ImmutableList<DevicesReportResponse>> counts;
    private final boolean ok;
    private final Optional<String> error;
    private final Optional<ErrorDetails> errorDetails;

    private DevicesReport(Builder builder) {
        this.dateClosed = Optional.ofNullable(builder.dateClosed);
        this.dateComputed = Optional.ofNullable(builder.dateComputed);
        this.totalUniqueDevices = Optional.ofNullable(builder.totalUniqueDevices);
        this.counts = Optional.ofNullable(builder.counts.build());
        this.ok = builder.ok;
        this.error = Optional.ofNullable(builder.error);
        this.errorDetails = Optional.ofNullable(builder.errorDetails);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Optional<String> getDateClosed() {
        return this.dateClosed;
    }

    public Optional<String> getDateComputed() {
        return this.dateComputed;
    }

    public Optional<Integer> getTotalUniqueDevices() {
        return this.totalUniqueDevices;
    }

    public Optional<ImmutableList<DevicesReportResponse>> getCounts() {
        return this.counts;
    }

    public boolean getOk() {
        return this.ok;
    }

    public Optional<String> getError() {
        return this.error;
    }

    public Optional<ErrorDetails> getErrorDetails() {
        return this.errorDetails;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DevicesReport)) {
            return false;
        }
        DevicesReport that = (DevicesReport)o;
        return Objects.equals(this.dateClosed, that.dateClosed) && Objects.equals(this.dateComputed, that.dateComputed) && Objects.equals(this.totalUniqueDevices, that.totalUniqueDevices) && Objects.equals(this.getCounts(), that.getCounts()) && Objects.equals(this.ok, that.ok) && Objects.equals(this.error, that.error) && Objects.equals(this.errorDetails, that.errorDetails);
    }

    public int hashCode() {
        return Objects.hash(this.dateClosed, this.dateComputed, this.totalUniqueDevices, this.getCounts(), this.ok, this.error, this.errorDetails);
    }

    public String toString() {
        return "DevicesReport{dateClosed=" + this.dateClosed + ", dateComputed=" + this.dateComputed + ", totalUniqueDevices=" + this.totalUniqueDevices + ", counts=" + this.counts + ", ok=" + this.ok + ", error=" + this.error + ", errorDetails=" + this.errorDetails + '}';
    }

    public static class Builder {
        private String dateClosed;
        private String dateComputed;
        private Integer totalUniqueDevices;
        private ImmutableList.Builder<DevicesReportResponse> counts = ImmutableList.builder();
        private boolean ok;
        private String error;
        private ErrorDetails errorDetails;

        private Builder() {
        }

        public Builder setDateClosed(String dateClosed) {
            this.dateClosed = dateClosed;
            return this;
        }

        public Builder setDateComputed(String dateComputed) {
            this.dateComputed = dateComputed;
            return this;
        }

        public Builder setTotalUniqueDevices(Integer totalUniqueDevices) {
            this.totalUniqueDevices = totalUniqueDevices;
            return this;
        }

        public Builder addDevicesReportResponseObject(DevicesReportResponse object) {
            this.counts.add((Object)object);
            return this;
        }

        public Builder setOk(boolean value) {
            this.ok = value;
            return this;
        }

        public Builder setError(String error) {
            this.error = error;
            return this;
        }

        public Builder setErrorDetails(ErrorDetails errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        public DevicesReport build() {
            return new DevicesReport(this);
        }
    }
}

