/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.reports.model;

import java.util.Objects;
import java.util.Optional;

public final class DeviceTypeStats {
    private final Optional<Integer> optedIn;
    private final Optional<Integer> optedOut;
    private final Optional<Integer> uninstalled;
    private final Optional<Integer> uniqueDevices;

    private DeviceTypeStats(Builder builder) {
        this.optedIn = Optional.ofNullable(builder.optedIn);
        this.optedOut = Optional.ofNullable(builder.optedOut);
        this.uninstalled = Optional.ofNullable(builder.uninstalled);
        this.uniqueDevices = Optional.ofNullable(builder.uniqueDevices);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Optional<Integer> getOptedIn() {
        return this.optedIn;
    }

    public Optional<Integer> getOptedOut() {
        return this.optedOut;
    }

    public Optional<Integer> getUninstalled() {
        return this.uninstalled;
    }

    public Optional<Integer> getUniqueDevices() {
        return this.uniqueDevices;
    }

    public int hashCode() {
        return Objects.hash(this.optedIn, this.optedOut, this.uninstalled, this.uniqueDevices);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DeviceTypeStats other = (DeviceTypeStats)obj;
        return Objects.equals(this.optedIn, other.optedIn) && Objects.equals(this.optedOut, other.optedOut) && Objects.equals(this.uninstalled, other.uninstalled) && Objects.equals(this.uniqueDevices, other.uniqueDevices);
    }

    public String toString() {
        return "DeviceTypeStats{optedIn=" + this.optedIn + ", optedOut=" + this.optedOut + ", uninstalled=" + this.uninstalled + ", uniqueDevices=" + this.uniqueDevices + '}';
    }

    public static class Builder {
        private int optedIn;
        private int optedOut;
        private int uninstalled;
        private int uniqueDevices;

        private Builder() {
        }

        public Builder setOptedIn(int value) {
            this.optedIn = value;
            return this;
        }

        public Builder setOptedOut(int value) {
            this.optedOut = value;
            return this;
        }

        public Builder setUninstalled(int value) {
            this.uninstalled = value;
            return this;
        }

        public Builder setUniqueDevices(int value) {
            this.uniqueDevices = value;
            return this;
        }

        public DeviceTypeStats build() {
            return new DeviceTypeStats(this);
        }
    }
}

