/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.reports;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestUtils;
import com.urbanairship.api.client.ResponseParser;
import com.urbanairship.api.common.parse.DateFormats;
import com.urbanairship.api.reports.model.PushListingResponse;
import com.urbanairship.api.reports.parse.ReportsObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class PushListingRequest
implements Request<PushListingResponse> {
    private static final String API_PUSH_RESPONSE_LISTING = "/api/reports/responses/list/";
    private final String path;
    private final boolean nextPageRequest;
    private DateTime start;
    private DateTime end;
    private Optional<Integer> limit = Optional.absent();
    private Optional<String> pushIdStart = Optional.absent();

    private PushListingRequest(String path, boolean nextPageRequest) {
        this.path = path;
        this.nextPageRequest = nextPageRequest;
    }

    public static PushListingRequest newRequest() {
        return new PushListingRequest(API_PUSH_RESPONSE_LISTING, false);
    }

    public static PushListingRequest newRequest(URI nextPage) {
        Preconditions.checkNotNull((Object)nextPage, (Object)"Next page URI cannot be null");
        return new PushListingRequest(nextPage.getPath() + "?" + nextPage.getQuery(), true);
    }

    public DateTime getStart() {
        return this.start;
    }

    public PushListingRequest setStart(DateTime start) {
        this.start = start;
        return this;
    }

    public DateTime getEnd() {
        return this.end;
    }

    public PushListingRequest setEnd(DateTime end) {
        this.end = end;
        return this;
    }

    public Optional<Integer> getLimit() {
        return this.limit;
    }

    public PushListingRequest setLimit(Integer limit) {
        this.limit = Optional.of((Object)limit);
        return this;
    }

    public Optional<String> getPushIdStart() {
        return this.pushIdStart;
    }

    public PushListingRequest setPushIdStart(String pushIdStart) {
        this.pushIdStart = Optional.of((Object)pushIdStart);
        return this;
    }

    @Override
    public ContentType getContentType() {
        return ContentType.APPLICATION_JSON;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/vnd.urbanairship+json; version=3");
        return headers;
    }

    @Override
    public Request.HttpMethod getHttpMethod() {
        return Request.HttpMethod.GET;
    }

    @Override
    public String getRequestBody() {
        return null;
    }

    @Override
    public URI getUri(URI baseUri) throws URISyntaxException {
        URIBuilder builder = new URIBuilder(RequestUtils.resolveURI(baseUri, this.path));
        if (!this.nextPageRequest) {
            Preconditions.checkNotNull((Object)this.start, (Object)"start cannot be null");
            Preconditions.checkNotNull((Object)this.end, (Object)"end cannot be null");
            Preconditions.checkArgument((boolean)this.end.isAfter((ReadableInstant)this.start), (Object)"end date must occur after start date");
            builder.addParameter("start", this.start.toString(DateFormats.DATE_FORMATTER));
            builder.addParameter("end", this.end.toString(DateFormats.DATE_FORMATTER));
            if (this.limit.isPresent()) {
                builder.addParameter("limit", Integer.toString((Integer)this.limit.get()));
            }
            if (this.pushIdStart.isPresent()) {
                builder.addParameter("push_id_start", (String)this.pushIdStart.get());
            }
        }
        return builder.build();
    }

    @Override
    public ResponseParser<PushListingResponse> getResponseParser() {
        return new ResponseParser<PushListingResponse>(){

            @Override
            public PushListingResponse parse(String response) throws IOException {
                return (PushListingResponse)ReportsObjectMapper.getInstance().readValue(response, PushListingResponse.class);
            }
        };
    }

    @Override
    public boolean bearerTokenAuthRequired() {
        return false;
    }

    @Override
    public boolean canUseBearerTokenAuth() {
        return true;
    }
}

