/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.reports;

import com.google.common.base.Preconditions;
import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestUtils;
import com.urbanairship.api.client.ResponseParser;
import com.urbanairship.api.common.parse.DateFormats;
import com.urbanairship.api.reports.PlatformStatsRequestType;
import com.urbanairship.api.reports.model.PlatformStatsResponse;
import com.urbanairship.api.reports.model.Precision;
import com.urbanairship.api.reports.parse.ReportsObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class PlatformStatsRequest
implements Request<PlatformStatsResponse> {
    private final String path;
    private final boolean nextPageRequest;
    private DateTime start;
    private DateTime end;
    private Precision precision;

    private PlatformStatsRequest(String path, boolean nextPageRequest) {
        this.path = path;
        this.nextPageRequest = nextPageRequest;
    }

    public static PlatformStatsRequest newRequest(PlatformStatsRequestType type) {
        return new PlatformStatsRequest(type.getPath(), false);
    }

    public static PlatformStatsRequest newRequest(URI nextPage) {
        Preconditions.checkNotNull((Object)nextPage, (Object)"Next page URI cannot be null");
        return new PlatformStatsRequest(nextPage.getPath() + "?" + nextPage.getQuery(), true);
    }

    public PlatformStatsRequest setStart(DateTime start) {
        this.start = start;
        return this;
    }

    public PlatformStatsRequest setEnd(DateTime end) {
        this.end = end;
        return this;
    }

    public PlatformStatsRequest setPrecision(Precision precision) {
        this.precision = precision;
        return this;
    }

    @Override
    public ContentType getContentType() {
        return ContentType.APPLICATION_JSON;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/vnd.urbanairship+json; version=3");
        return headers;
    }

    @Override
    public Request.HttpMethod getHttpMethod() {
        return Request.HttpMethod.GET;
    }

    @Override
    public String getRequestBody() {
        return null;
    }

    @Override
    public URI getUri(URI baseUri) {
        URI uri;
        URIBuilder builder = new URIBuilder(RequestUtils.resolveURI(baseUri, this.path));
        if (!this.nextPageRequest) {
            Preconditions.checkNotNull((Object)this.start, (Object)"start cannot be null");
            Preconditions.checkNotNull((Object)this.end, (Object)"end cannot be null");
            Preconditions.checkNotNull((Object)((Object)this.precision), (Object)"precision cannot be null");
            Preconditions.checkArgument((boolean)this.end.isAfter((ReadableInstant)this.start), (Object)"end date must occur after start date");
            builder.addParameter("start", this.start.toString(DateFormats.DATE_FORMATTER));
            builder.addParameter("end", this.end.toString(DateFormats.DATE_FORMATTER));
            builder.addParameter("precision", this.precision.toString());
        }
        try {
            uri = builder.build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return uri;
    }

    @Override
    public ResponseParser<PlatformStatsResponse> getResponseParser() {
        return new ResponseParser<PlatformStatsResponse>(){

            @Override
            public PlatformStatsResponse parse(String response) throws IOException {
                return (PlatformStatsResponse)ReportsObjectMapper.getInstance().readValue(response, PlatformStatsResponse.class);
            }
        };
    }

    @Override
    public boolean bearerTokenAuthRequired() {
        return false;
    }

    @Override
    public boolean canUseBearerTokenAuth() {
        return true;
    }
}

