/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.parse.notification.email;

import com.fasterxml.jackson.core.JsonParser;
import com.urbanairship.api.common.parse.APIParsingException;
import com.urbanairship.api.common.parse.JsonObjectReader;
import com.urbanairship.api.common.parse.StringFieldDeserializer;
import com.urbanairship.api.createandsend.model.notification.email.EmailTemplate;
import com.urbanairship.api.push.model.notification.email.EmailPayload;
import com.urbanairship.api.push.model.notification.email.MessageType;
import java.io.IOException;

public class EmailPayloadReader
implements JsonObjectReader<EmailPayload> {
    private final EmailPayload.Builder builder = EmailPayload.newBuilder();

    public void readSubject(JsonParser parser) throws IOException {
        this.builder.setSubject(StringFieldDeserializer.INSTANCE.deserialize(parser, "subject"));
    }

    public void readhtmlBody(JsonParser parser) throws IOException {
        this.builder.setHtmlBody(StringFieldDeserializer.INSTANCE.deserialize(parser, "html_body"));
    }

    public void readPlainTextBody(JsonParser parser) throws IOException {
        this.builder.setPlaintextBody(StringFieldDeserializer.INSTANCE.deserialize(parser, "plaintext_body"));
    }

    public void readMessageType(JsonParser parser) throws IOException {
        String messageType = StringFieldDeserializer.INSTANCE.deserialize(parser, "message_type");
        this.builder.setMessageType((MessageType)((Object)MessageType.find(messageType).get()));
    }

    public void readSenderName(JsonParser parser) throws IOException {
        this.builder.setSenderName(StringFieldDeserializer.INSTANCE.deserialize(parser, "sender_name"));
    }

    public void readSenderAddress(JsonParser parser) throws IOException {
        this.builder.setSenderAddress(StringFieldDeserializer.INSTANCE.deserialize(parser, "sender_address"));
    }

    public void readReplyTo(JsonParser parser) throws IOException {
        this.builder.setReplyTo(StringFieldDeserializer.INSTANCE.deserialize(parser, "reply_to"));
    }

    public void readTemplate(JsonParser jsonParser) throws IOException {
        this.builder.setTemplate((EmailTemplate)jsonParser.readValueAs(EmailTemplate.class));
    }

    @Override
    public EmailPayload validateAndBuild() throws IOException {
        try {
            return this.builder.build();
        }
        catch (Exception e) {
            throw new APIParsingException(e.getMessage(), e);
        }
    }
}

