/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.notification.open;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.urbanairship.api.push.model.DeviceType;
import com.urbanairship.api.push.model.PushModelObject;
import com.urbanairship.api.push.model.notification.DevicePayloadOverride;
import com.urbanairship.api.push.model.notification.Interactive;
import java.util.Map;

public final class OpenPayload
extends PushModelObject
implements DevicePayloadOverride {
    private final Optional<String> alert;
    private final Optional<String> title;
    private final Optional<ImmutableMap<String, String>> extras;
    private final Optional<String> summary;
    private final Optional<String> mediaAttachment;
    private final Optional<Interactive> interactive;
    private final DeviceType deviceType;

    private OpenPayload(Builder builder) {
        this.alert = Optional.fromNullable((Object)builder.alert);
        this.title = Optional.fromNullable((Object)builder.title);
        this.extras = builder.extras.build().isEmpty() ? Optional.absent() : Optional.of((Object)builder.extras.build());
        this.summary = Optional.fromNullable((Object)builder.summary);
        this.mediaAttachment = Optional.fromNullable((Object)builder.mediaAttachment);
        this.interactive = Optional.fromNullable((Object)builder.interactive);
        this.deviceType = builder.deviceType;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public DeviceType getDeviceType() {
        return this.deviceType;
    }

    @Override
    public Optional<String> getAlert() {
        return this.alert;
    }

    public Optional<String> getTitle() {
        return this.title;
    }

    public Optional<ImmutableMap<String, String>> getExtras() {
        return this.extras;
    }

    public Optional<String> getSummary() {
        return this.summary;
    }

    public Optional<String> getMediaAttachment() {
        return this.mediaAttachment;
    }

    public Optional<Interactive> getInteractive() {
        return this.interactive;
    }

    public String toString() {
        return "OpenPayload{alert=" + this.alert + ", title=" + this.title + ", extras=" + this.extras + ", summary=" + this.summary + ", mediaAttachment=" + this.mediaAttachment + ", interactive=" + this.interactive + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenPayload that = (OpenPayload)o;
        return Objects.equal(this.alert, that.alert) && Objects.equal(this.title, that.title) && Objects.equal(this.extras, that.extras) && Objects.equal(this.summary, that.summary) && Objects.equal(this.mediaAttachment, that.mediaAttachment) && Objects.equal(this.interactive, that.interactive);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.alert, this.title, this.extras, this.summary, this.mediaAttachment, this.interactive});
    }

    public static class Builder {
        private DeviceType deviceType = null;
        private String alert = null;
        private String title = null;
        private ImmutableMap.Builder<String, String> extras = ImmutableMap.builder();
        private String summary = null;
        private String mediaAttachment = null;
        private Interactive interactive = null;

        private Builder() {
        }

        public Builder setAlert(String alert) {
            this.alert = alert;
            return this;
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setExtras(Map<String, String> entries) {
            this.extras.putAll(entries);
            return this;
        }

        public Builder setSummary(String summary) {
            this.summary = summary;
            return this;
        }

        public Builder setMediaAttachment(String mediaAttachment) {
            this.mediaAttachment = mediaAttachment;
            return this;
        }

        public Builder setDeviceType(DeviceType deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        public Builder setInteractive(Interactive interactive) {
            this.interactive = interactive;
            return this;
        }

        public OpenPayload build() {
            Preconditions.checkNotNull((Object)this.deviceType, (Object)"DeviceType must be set.");
            return new OpenPayload(this);
        }
    }
}

