/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.notification.adm;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.urbanairship.api.push.model.DeviceType;
import com.urbanairship.api.push.model.PushExpiry;
import com.urbanairship.api.push.model.PushModelObject;
import com.urbanairship.api.push.model.notification.DevicePayloadOverride;
import com.urbanairship.api.push.model.notification.Interactive;
import com.urbanairship.api.push.model.notification.actions.Actions;
import com.urbanairship.api.push.model.notification.adm.ADMTemplate;
import com.urbanairship.api.push.model.notification.android.Style;
import java.util.Map;

public final class ADMDevicePayload
extends PushModelObject
implements DevicePayloadOverride {
    private final Optional<String> alert;
    private final Optional<String> consolidationKey;
    private final Optional<PushExpiry> expiresAfter;
    private final Optional<ImmutableMap<String, String>> extra;
    private final Optional<Interactive> interactive;
    private final Optional<Actions> actions;
    private final Optional<String> icon;
    private final Optional<String> iconColor;
    private final Optional<String> notificationChannel;
    private final Optional<String> notificationTag;
    private final Optional<String> sound;
    private final Optional<String> summary;
    private final Optional<String> title;
    private final Optional<Style> style;
    private final Optional<ADMTemplate> template;

    private ADMDevicePayload(Builder builder) {
        this.alert = Optional.fromNullable((Object)builder.alert);
        this.consolidationKey = Optional.fromNullable((Object)builder.consolidationKey);
        this.expiresAfter = Optional.fromNullable((Object)builder.expiresAfter);
        this.extra = builder.extra.build().isEmpty() ? Optional.absent() : Optional.of((Object)builder.extra.build());
        this.interactive = Optional.fromNullable((Object)builder.interactive);
        this.actions = Optional.fromNullable((Object)builder.actions);
        this.icon = Optional.fromNullable((Object)builder.icon);
        this.iconColor = Optional.fromNullable((Object)builder.iconColor);
        this.notificationChannel = Optional.fromNullable((Object)builder.notificationChannel);
        this.notificationTag = Optional.fromNullable((Object)builder.notificationTag);
        this.sound = Optional.fromNullable((Object)builder.sound);
        this.summary = Optional.fromNullable((Object)builder.summary);
        this.title = Optional.fromNullable((Object)builder.title);
        this.style = Optional.fromNullable((Object)builder.style);
        this.template = Optional.fromNullable((Object)builder.template);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public DeviceType getDeviceType() {
        return DeviceType.AMAZON;
    }

    @Override
    public Optional<String> getAlert() {
        return this.alert;
    }

    public Optional<String> getConsolidationKey() {
        return this.consolidationKey;
    }

    public Optional<PushExpiry> getExpiresAfter() {
        return this.expiresAfter;
    }

    public Optional<ImmutableMap<String, String>> getExtra() {
        return this.extra;
    }

    public Optional<Interactive> getInteractive() {
        return this.interactive;
    }

    public Optional<Actions> getActions() {
        return this.actions;
    }

    public Optional<String> getIcon() {
        return this.icon;
    }

    public Optional<String> getIconColor() {
        return this.iconColor;
    }

    public Optional<String> getNotificationChannel() {
        return this.notificationChannel;
    }

    public Optional<String> getNotificationTag() {
        return this.notificationTag;
    }

    public Optional<String> getSound() {
        return this.sound;
    }

    public Optional<String> getSummary() {
        return this.summary;
    }

    public Optional<String> getTitle() {
        return this.title;
    }

    public Optional<Style> getStyle() {
        return this.style;
    }

    public Optional<ADMTemplate> getTemplate() {
        return this.template;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ADMDevicePayload that = (ADMDevicePayload)o;
        return Objects.equal(this.alert, that.alert) && Objects.equal(this.consolidationKey, that.consolidationKey) && Objects.equal(this.expiresAfter, that.expiresAfter) && Objects.equal(this.extra, that.extra) && Objects.equal(this.interactive, that.interactive) && Objects.equal(this.actions, that.actions) && Objects.equal(this.icon, that.icon) && Objects.equal(this.iconColor, that.iconColor) && Objects.equal(this.notificationChannel, that.notificationChannel) && Objects.equal(this.notificationTag, that.notificationTag) && Objects.equal(this.sound, that.sound) && Objects.equal(this.summary, that.summary) && Objects.equal(this.title, that.title) && Objects.equal(this.style, that.style) && Objects.equal(this.template, that.template);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.alert, this.consolidationKey, this.expiresAfter, this.extra, this.interactive, this.actions, this.icon, this.iconColor, this.notificationChannel, this.notificationTag, this.sound, this.summary, this.title, this.style, this.template});
    }

    public static class Builder {
        private String alert = null;
        private String consolidationKey = null;
        private PushExpiry expiresAfter = null;
        private ImmutableMap.Builder<String, String> extra = ImmutableMap.builder();
        private Interactive interactive = null;
        private Actions actions = null;
        private String icon = null;
        private String iconColor = null;
        private String notificationChannel = null;
        private String notificationTag = null;
        private String sound = null;
        private String summary = null;
        private String title = null;
        private Style style = null;
        private ADMTemplate template = null;

        private Builder() {
        }

        public Builder setAlert(String alert) {
            this.alert = alert;
            return this;
        }

        public Builder setConsolidationKey(String consolidationKey) {
            this.consolidationKey = consolidationKey;
            return this;
        }

        public Builder setExpiresAfter(PushExpiry value) {
            this.expiresAfter = value;
            return this;
        }

        public Builder addExtraEntry(String key, String value) {
            this.extra.put((Object)key, (Object)value);
            return this;
        }

        public Builder addAllExtraEntries(Map<String, String> entries) {
            this.extra.putAll(entries);
            return this;
        }

        public Builder setInteractive(Interactive value) {
            this.interactive = value;
            return this;
        }

        public Builder setActions(Actions actions) {
            this.actions = actions;
            return this;
        }

        public Builder setIcon(String icon) {
            this.icon = icon;
            return this;
        }

        public Builder setIconColor(String iconColor) {
            this.iconColor = iconColor;
            return this;
        }

        public Builder setNotificationChannel(String notificationChannel) {
            this.notificationChannel = notificationChannel;
            return this;
        }

        public Builder setNotificationTag(String notificationTag) {
            this.notificationTag = notificationTag;
            return this;
        }

        public Builder setSound(String sound) {
            this.sound = sound;
            return this;
        }

        public Builder setSummary(String summary) {
            this.summary = summary;
            return this;
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setStyle(Style style) {
            this.style = style;
            return this;
        }

        public Builder setTemplate(ADMTemplate template) {
            this.template = template;
            return this;
        }

        public ADMDevicePayload build() {
            return new ADMDevicePayload(this);
        }
    }
}

