/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;

public final class DeviceType {
    public static final DeviceType AMAZON = new DeviceType(PlatformType.NATIVE, "amazon");
    public static final DeviceType ANDROID = new DeviceType(PlatformType.NATIVE, "android");
    public static final DeviceType IOS = new DeviceType(PlatformType.NATIVE, "ios");
    public static final DeviceType WEB = new DeviceType(PlatformType.NATIVE, "web");
    public static final DeviceType WNS = new DeviceType(PlatformType.NATIVE, "wns");
    public static final DeviceType SMS = new DeviceType(PlatformType.NATIVE, "sms");
    public static final DeviceType EMAIL = new DeviceType(PlatformType.NATIVE, "email");
    public static final ImmutableSet<DeviceType> TYPES = ImmutableSet.builder().add((Object)AMAZON).add((Object)ANDROID).add((Object)IOS).add((Object)WEB).add((Object)WNS).add((Object)SMS).add((Object)EMAIL).build();
    private static final String OPEN_PLATFORM_NAMESPACE = "open::";
    private final String identifier;
    private final PlatformType platformType;

    public static DeviceType open(String platformName) {
        return new DeviceType(PlatformType.OPEN, OPEN_PLATFORM_NAMESPACE + platformName);
    }

    private DeviceType(PlatformType platformType, String identifier) {
        this.platformType = platformType;
        this.identifier = identifier;
    }

    public boolean isOpenPlatform() {
        return this.platformType.equals((Object)PlatformType.OPEN);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public static Optional<DeviceType> find(String identifier) {
        for (DeviceType deviceType : TYPES) {
            if (!deviceType.getIdentifier().equals(identifier)) continue;
            return Optional.of((Object)deviceType);
        }
        if (identifier.contains(OPEN_PLATFORM_NAMESPACE)) {
            return Optional.of((Object)new DeviceType(PlatformType.OPEN, identifier));
        }
        return Optional.absent();
    }

    public String toString() {
        return this.identifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeviceType that = (DeviceType)o;
        return Objects.equals(this.identifier, that.identifier) && this.platformType == that.platformType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifier, this.platformType});
    }

    private static enum PlatformType {
        NATIVE,
        OPEN;

    }
}

