/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.client;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class Response<T> {
    private final Optional<T> body;
    private final ImmutableMap<String, String> headers;
    private final int status;

    Response(T body, Map<String, String> headers, int status) {
        this.body = Optional.fromNullable(body);
        this.headers = ImmutableMap.copyOf(headers);
        this.status = status;
    }

    public Optional<T> getBody() {
        return this.body;
    }

    public ImmutableMap<String, String> getHeaders() {
        return this.headers;
    }

    public int getStatus() {
        return this.status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Response)) {
            return false;
        }
        Response response = (Response)o;
        if (this.status != response.status) {
            return false;
        }
        if (!this.body.equals(response.body)) {
            return false;
        }
        return this.headers.equals(response.headers);
    }

    public int hashCode() {
        int result = this.body.hashCode();
        result = 31 * result + this.headers.hashCode();
        result = 31 * result + this.status;
        return result;
    }

    public String toString() {
        return "Response{body=" + this.body + ", headers=" + this.headers + ", status=" + this.status + '}';
    }

    public static class Builder<T> {
        private T body = null;
        private Map<String, String> headers;
        private int status;

        public Builder setBody(T body) {
            this.body = body;
            return this;
        }

        public Builder setHeaders(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public Builder setStatus(int status) {
            this.status = status;
            return this;
        }

        public Response build() {
            return new Response<T>(this.body, this.headers, this.status);
        }
    }
}

