/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.channel.model.sms;

import com.google.common.base.Preconditions;
import com.urbanairship.api.channel.model.sms.UpdateSmsChannel;
import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestUtils;
import com.urbanairship.api.client.ResponseParser;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.entity.ContentType;

public class UpdateSmsChannelRequest
implements Request<String> {
    private static final String API_UPDATE_SMS_CHANNEL = "/api/channels/sms/";
    private final String path;
    private final UpdateSmsChannel payload;

    private UpdateSmsChannelRequest(String path, UpdateSmsChannel payload) {
        this.path = path;
        this.payload = payload;
    }

    public static UpdateSmsChannelRequest newRequest(String channelId, UpdateSmsChannel payload) {
        Preconditions.checkNotNull((Object)payload, (Object)"Payload must not be null to create an RegisterEmail channel request");
        Preconditions.checkNotNull((Object)channelId, (Object)"ChannelId must not be null to create an RegisterEmail channel request");
        return new UpdateSmsChannelRequest(API_UPDATE_SMS_CHANNEL + channelId, payload);
    }

    @Override
    public Request.HttpMethod getHttpMethod() {
        return Request.HttpMethod.PUT;
    }

    @Override
    public String getRequestBody() {
        return this.payload.toJSON();
    }

    @Override
    public ContentType getContentType() {
        return ContentType.APPLICATION_JSON;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/vnd.urbanairship+json; version=3");
        return headers;
    }

    @Override
    public URI getUri(URI baseUri) throws URISyntaxException {
        return RequestUtils.resolveURI(baseUri, this.path);
    }

    @Override
    public ResponseParser<String> getResponseParser() {
        return new ResponseParser<String>(){

            @Override
            public String parse(String response) throws IOException {
                return response;
            }
        };
    }

    @Override
    public boolean bearerTokenAuthRequired() {
        return false;
    }

    @Override
    public boolean canUseBearerTokenAuth() {
        return true;
    }
}

