/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.channel;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.urbanairship.api.channel.model.ChannelUninstallResponse;
import com.urbanairship.api.channel.parse.ChannelObjectMapper;
import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestUtils;
import com.urbanairship.api.client.ResponseParser;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.entity.ContentType;

public class OpenChannelUninstallRequest
implements Request<ChannelUninstallResponse> {
    private static final String API_OPEN_CHANNEL_UNINSTALL = "/api/channels/open/uninstall";
    private static final ObjectMapper MAPPER = ChannelObjectMapper.getInstance();
    private final Map<String, String> payload = new HashMap<String, String>();

    private OpenChannelUninstallRequest(String address, String openPlatformName) {
        Preconditions.checkNotNull((Object)address, (Object)"address must not be null to uninstall an open channel");
        Preconditions.checkNotNull((Object)openPlatformName, (Object)"openPlatformName must not be null to uninstall an open channel");
        this.payload.put("address", address);
        this.payload.put("open_platform_name", openPlatformName);
    }

    public static OpenChannelUninstallRequest newRequest(String address, String openPlatformName) {
        return new OpenChannelUninstallRequest(address, openPlatformName);
    }

    @Override
    public Request.HttpMethod getHttpMethod() {
        return Request.HttpMethod.POST;
    }

    @Override
    public String getRequestBody() {
        try {
            return ChannelObjectMapper.getInstance().writeValueAsString(this.payload);
        }
        catch (Exception e) {
            return "{ \"exception\" : \"" + e.getClass().getName() + "\", \"message\" : \"" + e.getMessage() + "\" }";
        }
    }

    @Override
    public ContentType getContentType() {
        return ContentType.APPLICATION_JSON;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/vnd.urbanairship+json; version=3");
        return headers;
    }

    @Override
    public URI getUri(URI baseUri) throws URISyntaxException {
        return RequestUtils.resolveURI(baseUri, API_OPEN_CHANNEL_UNINSTALL);
    }

    @Override
    public ResponseParser<ChannelUninstallResponse> getResponseParser() {
        return new ResponseParser<ChannelUninstallResponse>(){

            @Override
            public ChannelUninstallResponse parse(String response) throws IOException {
                return (ChannelUninstallResponse)MAPPER.readValue(response, ChannelUninstallResponse.class);
            }
        };
    }

    @Override
    public boolean bearerTokenAuthRequired() {
        return false;
    }

    @Override
    public boolean canUseBearerTokenAuth() {
        return true;
    }
}

