/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.staticlists;

import com.google.common.base.Preconditions;
import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestUtils;
import com.urbanairship.api.client.ResponseParser;
import com.urbanairship.api.staticlists.parse.StaticListsObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.http.entity.ContentType;

public class StaticListRequest
implements Request<String> {
    private static final String API_LISTS_PATH = "/api/lists/";
    private final String path;
    private static final String NAME_KEY = "name";
    private static final String DESCRIPTION_KEY = "description";
    private static final String EXTRAS_KEY = "extra";
    private final Map<String, String> extras = new HashMap<String, String>();
    private final Map<String, Object> payload = new HashMap<String, Object>();

    private StaticListRequest(String path, String name) {
        this.path = path;
        this.payload.put(NAME_KEY, name);
    }

    public static StaticListRequest newRequest(String name) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)name), (Object)"List name cannot be empty.");
        return new StaticListRequest(API_LISTS_PATH, name);
    }

    public static StaticListRequest newUpdateRequest(String name) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)name), (Object)"List name cannot be empty.");
        return new StaticListRequest(API_LISTS_PATH + name, name);
    }

    public StaticListRequest setDescription(String description) {
        this.payload.put(DESCRIPTION_KEY, description);
        return this;
    }

    public StaticListRequest addExtra(String key, String val) {
        this.extras.put(key, val);
        return this;
    }

    public StaticListRequest addAllExtras(Map<String, String> entries) {
        this.extras.putAll(entries);
        return this;
    }

    @Override
    public ContentType getContentType() {
        return ContentType.APPLICATION_JSON;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/vnd.urbanairship+json; version=3");
        return headers;
    }

    @Override
    public Request.HttpMethod getHttpMethod() {
        if (this.path.equals(API_LISTS_PATH)) {
            return Request.HttpMethod.POST;
        }
        return Request.HttpMethod.PUT;
    }

    @Override
    public String getRequestBody() {
        if (!this.extras.isEmpty()) {
            this.payload.put(EXTRAS_KEY, this.extras);
        }
        try {
            return StaticListsObjectMapper.getInstance().writeValueAsString(this.payload);
        }
        catch (Exception ex) {
            return "{ \"exception\" : \"" + ex.getClass().getName() + "\", \"message\" : \"" + ex.getMessage() + "\" }";
        }
    }

    @Override
    public URI getUri(URI baseUri) {
        return RequestUtils.resolveURI(baseUri, this.path);
    }

    @Override
    public ResponseParser<String> getResponseParser() {
        return new ResponseParser<String>(){

            @Override
            public String parse(String response) throws IOException {
                return response;
            }
        };
    }

    @Override
    public boolean bearerTokenAuthRequired() {
        return false;
    }
}

