/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.segments;

import com.google.common.base.Preconditions;
import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestUtils;
import com.urbanairship.api.client.ResponseParser;
import com.urbanairship.api.segments.model.SegmentView;
import com.urbanairship.api.segments.parse.SegmentObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.http.entity.ContentType;

public class SegmentLookupRequest
implements Request<SegmentView> {
    private static final String API_SEGMENTS_PATH = "/api/segments/";
    private final String path;

    private SegmentLookupRequest(String path) {
        this.path = path;
    }

    public static SegmentLookupRequest newRequest(String segmentId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)segmentId), (Object)"Segment ID may not be null.");
        return new SegmentLookupRequest(API_SEGMENTS_PATH + segmentId);
    }

    @Override
    public ContentType getContentType() {
        return null;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/vnd.urbanairship+json; version=3");
        return headers;
    }

    @Override
    public Request.HttpMethod getHttpMethod() {
        return Request.HttpMethod.GET;
    }

    @Override
    public String getRequestBody() {
        return null;
    }

    @Override
    public URI getUri(URI baseUri) {
        return RequestUtils.resolveURI(baseUri, this.path);
    }

    @Override
    public ResponseParser<SegmentView> getResponseParser() {
        return new ResponseParser<SegmentView>(){

            @Override
            public SegmentView parse(String response) throws IOException {
                return (SegmentView)SegmentObjectMapper.getInstance().readValue(response, SegmentView.class);
            }
        };
    }

    @Override
    public boolean bearerTokenAuthRequired() {
        return false;
    }
}

