/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.reports.parse;

import com.fasterxml.jackson.core.JsonParser;
import com.urbanairship.api.common.parse.APIParsingException;
import com.urbanairship.api.common.parse.DateFormats;
import com.urbanairship.api.common.parse.JsonObjectReader;
import com.urbanairship.api.reports.model.StatisticsResponse;
import java.io.IOException;

public final class StatisticsResponseReader
implements JsonObjectReader<StatisticsResponse> {
    private final StatisticsResponse.Builder builder = StatisticsResponse.newBuilder();

    public void readStartTime(JsonParser jsonParser) throws IOException {
        String created = (String)jsonParser.readValueAs(String.class);
        this.builder.setStartTime(DateFormats.DATE_PARSER.parseDateTime(created));
    }

    public void readiOSCount(JsonParser jsonParser) throws IOException {
        this.builder.setIosCount((Integer)jsonParser.readValueAs(Integer.class));
    }

    public void readBlackBerryCount(JsonParser jsonParser) throws IOException {
        this.builder.setBlackBerryCount((Integer)jsonParser.readValueAs(Integer.class));
    }

    public void readC2DMCount(JsonParser jsonParser) throws IOException {
        this.builder.setC2dmCount((Integer)jsonParser.readValueAs(Integer.class));
    }

    public void readGCMCount(JsonParser jsonParser) throws IOException {
        this.builder.setGcmCount((Integer)jsonParser.readValueAs(Integer.class));
    }

    public void readWindows8Count(JsonParser jsonParser) throws IOException {
        this.builder.setWindows8Count((Integer)jsonParser.readValueAs(Integer.class));
    }

    public void readWindowsPhone8Count(JsonParser jsonParser) throws IOException {
        this.builder.setWindowsPhone8Count((Integer)jsonParser.readValueAs(Integer.class));
    }

    @Override
    public StatisticsResponse validateAndBuild() throws IOException {
        try {
            return this.builder.build();
        }
        catch (Exception e) {
            throw new APIParsingException(e.getMessage());
        }
    }
}

