/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.reports.model;

import com.google.common.base.Objects;
import org.joda.time.DateTime;

public final class PlatformStats {
    private final int android;
    private final int ios;
    private final DateTime date;

    private PlatformStats(int android, int ios, DateTime date) {
        this.android = android;
        this.ios = ios;
        this.date = date;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public int getAndroid() {
        return this.android;
    }

    public int getIos() {
        return this.ios;
    }

    public DateTime getDate() {
        return this.date;
    }

    public String toString() {
        return "PlatformStats{android=" + this.android + ", ios=" + this.ios + ", date=" + this.date + '}';
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.android, this.ios, this.date});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PlatformStats other = (PlatformStats)obj;
        return Objects.equal((Object)this.android, (Object)other.android) && Objects.equal((Object)this.ios, (Object)other.ios) && Objects.equal((Object)this.date, (Object)other.date);
    }

    public static class Builder {
        private int android;
        private int ios;
        private DateTime date;

        private Builder() {
        }

        public Builder setAndroid(int value) {
            this.android = value;
            return this;
        }

        public Builder setIOS(int value) {
            this.ios = value;
            return this;
        }

        public Builder setDate(DateTime value) {
            this.date = value;
            return this;
        }

        public PlatformStats build() {
            return new PlatformStats(this.android, this.ios, this.date);
        }
    }
}

