/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.parse.notification.ios;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.urbanairship.api.common.parse.APIParsingException;
import com.urbanairship.api.common.parse.BooleanFieldDeserializer;
import com.urbanairship.api.common.parse.JsonObjectReader;
import com.urbanairship.api.common.parse.MapOfStringsDeserializer;
import com.urbanairship.api.common.parse.StringFieldDeserializer;
import com.urbanairship.api.push.model.PushExpiry;
import com.urbanairship.api.push.model.notification.Interactive;
import com.urbanairship.api.push.model.notification.ios.IOSDevicePayload;
import com.urbanairship.api.push.parse.notification.ios.IOSAlertDataDeserializer;
import com.urbanairship.api.push.parse.notification.ios.IOSBadgeDataDeserializer;
import com.urbanairship.api.push.parse.notification.ios.MediaAttachmentDeserializer;
import java.io.IOException;

public class IOSDevicePayloadReader
implements JsonObjectReader<IOSDevicePayload> {
    private IOSDevicePayload.Builder builder = IOSDevicePayload.newBuilder();
    private IOSAlertDataDeserializer alertDS = new IOSAlertDataDeserializer();
    private MediaAttachmentDeserializer mediaAttachmentDS = new MediaAttachmentDeserializer();

    public void readAlert(JsonParser parser, DeserializationContext context) throws IOException {
        this.builder.setAlert(this.alertDS.deserialize(parser, context));
    }

    public void readSound(JsonParser parser) throws IOException {
        this.builder.setSound(StringFieldDeserializer.INSTANCE.deserialize(parser, "sound"));
    }

    public void readBadge(JsonParser parser) throws IOException {
        this.builder.setBadge(IOSBadgeDataDeserializer.INSTANCE.deserialize(parser));
    }

    public void readContentAvailable(JsonParser parser) throws IOException {
        this.builder.setContentAvailable(BooleanFieldDeserializer.INSTANCE.deserialize(parser, "content_available"));
    }

    public void readExtra(JsonParser parser) throws IOException {
        this.builder.addAllExtraEntries(MapOfStringsDeserializer.INSTANCE.deserialize(parser, "extra"));
    }

    public void readCategory(JsonParser parser) throws IOException {
        this.builder.setCategory(StringFieldDeserializer.INSTANCE.deserialize(parser, "category"));
    }

    public void readInteractive(JsonParser parser) throws IOException {
        this.builder.setInteractive((Interactive)parser.readValueAs(Interactive.class));
    }

    public void readExpiry(JsonParser parser) throws IOException {
        this.builder.setExpiry((PushExpiry)parser.readValueAs(PushExpiry.class));
    }

    public void readPriority(JsonParser parser) throws IOException {
        this.builder.setPriority(parser.getIntValue());
    }

    public void readTitle(JsonParser parser) throws IOException {
        this.builder.setTitle(StringFieldDeserializer.INSTANCE.deserialize(parser, "title"));
    }

    public void readSubtitle(JsonParser parser) throws IOException {
        this.builder.setSubtitle(StringFieldDeserializer.INSTANCE.deserialize(parser, "subtitle"));
    }

    public void readMutableContent(JsonParser parser) throws IOException {
        this.builder.setMutableContent(BooleanFieldDeserializer.INSTANCE.deserialize(parser, "mutable_content"));
    }

    public void readMediaAttachment(JsonParser parser, DeserializationContext context) throws IOException {
        this.builder.setMediaAttachment(this.mediaAttachmentDS.deserialize(parser, context));
    }

    public void readCollapseId(JsonParser parser) throws IOException {
        this.builder.setCollapseId(StringFieldDeserializer.INSTANCE.deserialize(parser, "collapse_id"));
    }

    @Override
    public IOSDevicePayload validateAndBuild() throws IOException {
        try {
            return this.builder.build();
        }
        catch (Exception e) {
            throw new APIParsingException(e.getMessage(), e);
        }
    }
}

