/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.notification.android;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;

public class PublicNotification {
    private final Optional<String> title;
    private final Optional<String> alert;
    private final Optional<String> summary;

    private PublicNotification(Builder builder) {
        this.title = Optional.fromNullable((Object)builder.title);
        this.alert = Optional.fromNullable((Object)builder.alert);
        this.summary = Optional.fromNullable((Object)builder.summary);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Optional<String> getSummary() {
        return this.summary;
    }

    public Optional<String> getTitle() {
        return this.title;
    }

    public Optional<String> getAlert() {
        return this.alert;
    }

    public String toString() {
        return "PublicNotification{title=" + this.title + ", alert=" + this.alert + ", summary=" + this.summary + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PublicNotification that = (PublicNotification)o;
        if (!this.alert.equals(that.alert)) {
            return false;
        }
        if (!this.summary.equals(that.summary)) {
            return false;
        }
        return this.title.equals(that.title);
    }

    public int hashCode() {
        int result = this.title.hashCode();
        result = 31 * result + this.alert.hashCode();
        result = 31 * result + this.summary.hashCode();
        return result;
    }

    public static class Builder {
        private String summary = null;
        private String title = null;
        private String alert = null;

        public Builder setSummary(String summary) {
            this.summary = summary;
            return this;
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setAlert(String alert) {
            this.alert = alert;
            return this;
        }

        public PublicNotification build() {
            Preconditions.checkArgument((this.summary != null || this.title != null || this.alert != null ? 1 : 0) != 0, (Object)"At least one of summary, title, or alert must be set.");
            return new PublicNotification(this);
        }
    }
}

