/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.nameduser.parse;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.urbanairship.api.channel.model.ChannelView;
import com.urbanairship.api.channel.model.ios.IosSettings;
import com.urbanairship.api.channel.model.ios.QuietTime;
import com.urbanairship.api.channel.parse.ChannelViewDeserializer;
import com.urbanairship.api.channel.parse.ios.IosSettingsDeserializer;
import com.urbanairship.api.channel.parse.ios.QuietTimeDeserializer;
import com.urbanairship.api.nameduser.model.NamedUserListingResponse;
import com.urbanairship.api.nameduser.model.NamedUserView;
import com.urbanairship.api.nameduser.parse.NamedUserViewDeserializer;
import com.urbanairship.api.nameduser.parse.NamedUserlListingResponseDeserializer;
import com.urbanairship.api.push.parse.PushObjectMapper;

public class NamedUserObjectMapper {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final SimpleModule MODULE = new SimpleModule("Named User API Module", new Version(1, 0, 0, null));

    public static SimpleModule getModule() {
        return MODULE;
    }

    public static ObjectMapper getInstance() {
        return MAPPER;
    }

    private NamedUserObjectMapper() {
    }

    static {
        MODULE.addDeserializer(IosSettings.class, (JsonDeserializer)new IosSettingsDeserializer());
        MODULE.addDeserializer(QuietTime.class, (JsonDeserializer)new QuietTimeDeserializer());
        MODULE.addDeserializer(ChannelView.class, (JsonDeserializer)new ChannelViewDeserializer());
        MODULE.addDeserializer(NamedUserView.class, (JsonDeserializer)new NamedUserViewDeserializer());
        MODULE.addDeserializer(NamedUserListingResponse.class, (JsonDeserializer)new NamedUserlListingResponseDeserializer());
        MAPPER.registerModule((Module)MODULE);
        MAPPER.registerModule((Module)PushObjectMapper.getModule());
        MAPPER.registerModule((Module)new JodaModule());
        MAPPER.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
    }
}

