/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.location.model;

import com.google.common.base.Preconditions;

public final class Point {
    private final double latitude;
    private final double longitude;

    private Point(double latitude, double longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Point point = (Point)o;
        if (Double.compare(point.latitude, this.latitude) != 0) {
            return false;
        }
        return Double.compare(point.longitude, this.longitude) == 0;
    }

    public int hashCode() {
        long temp = this.latitude != 0.0 ? Double.doubleToLongBits(this.latitude) : 0L;
        int result = (int)(temp ^ temp >>> 32);
        temp = this.longitude != 0.0 ? Double.doubleToLongBits(this.longitude) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "Point{latitude=" + this.latitude + ", longitude=" + this.longitude + '}';
    }

    public static class Builder {
        private double latitude;
        private double longitude;

        private Builder() {
        }

        public Builder setLatitude(double value) {
            this.latitude = value;
            return this;
        }

        public Builder setLongitude(double value) {
            this.longitude = value;
            return this;
        }

        public Point build() {
            Preconditions.checkArgument((this.latitude >= -90.0 && this.latitude <= 90.0 ? 1 : 0) != 0, (Object)"latitude must be valid");
            Preconditions.checkArgument((this.longitude >= -180.0 && this.longitude <= 180.0 ? 1 : 0) != 0, (Object)"longitude must be valid");
            return new Point(this.latitude, this.longitude);
        }
    }
}

