/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.location.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.urbanairship.api.location.model.BoundedBox;
import com.urbanairship.api.location.model.Point;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public final class LocationView {
    private final String locationId;
    private final String locationType;
    private final JsonNode propertiesJsonNode;
    private final Optional<Point> centroid;
    private final Optional<BoundedBox> bounds;

    private LocationView(String locationId, String locationType, JsonNode propertiesJsonNode, Optional<Point> centroid, Optional<BoundedBox> bounds) {
        this.locationId = locationId;
        this.locationType = locationType;
        this.propertiesJsonNode = propertiesJsonNode;
        this.centroid = centroid;
        this.bounds = bounds;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getLocationId() {
        return this.locationId;
    }

    public String getLocationType() {
        return this.locationType;
    }

    public String getPropertiesJsonString() {
        return this.propertiesJsonNode.toString();
    }

    public JsonNode getPropertiesJsonNode() {
        return this.propertiesJsonNode;
    }

    public Optional<Point> getCentroid() {
        return this.centroid;
    }

    public Optional<BoundedBox> getBounds() {
        return this.bounds;
    }

    public String toString() {
        return "Location{locationId='" + this.locationId + '\'' + ", locationType='" + this.locationType + '\'' + ", propertiesJsonNode=" + this.propertiesJsonNode + ", centroid=" + this.centroid + ", bounds=" + this.bounds + '}';
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.locationId, this.locationType, this.propertiesJsonNode, this.centroid, this.bounds});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LocationView other = (LocationView)obj;
        return Objects.equal((Object)this.locationId, (Object)other.locationId) && Objects.equal((Object)this.locationType, (Object)other.locationType) && Objects.equal((Object)this.propertiesJsonNode, (Object)other.propertiesJsonNode) && Objects.equal(this.centroid, other.centroid) && Objects.equal(this.bounds, other.bounds);
    }

    public static class Builder {
        private String locationId = null;
        private String locationType = null;
        private JsonNode propertiesJsonNode = null;
        private Point centroid = null;
        private BoundedBox bounds = null;

        private Builder() {
        }

        public Builder setLocationId(String locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder setLocationType(String locationType) {
            this.locationType = locationType;
            return this;
        }

        public Builder setPropertiesNode(JsonNode propertiesJsonNode) {
            this.propertiesJsonNode = propertiesJsonNode;
            return this;
        }

        public Builder setCentroid(Point centroid) {
            this.centroid = centroid;
            return this;
        }

        public Builder setCentroid(List<Double> value) {
            Preconditions.checkArgument((value.size() == 2 ? 1 : 0) != 0, (Object)"Need two values to set a point.");
            this.centroid = Point.newBuilder().setLatitude(value.get(0)).setLongitude(value.get(1)).build();
            return this;
        }

        public Builder setBounds(BoundedBox bounds) {
            this.bounds = bounds;
            return this;
        }

        public Builder setBounds(List<Double> value) {
            Preconditions.checkArgument((value.size() == 4 ? 1 : 0) != 0, (Object)"Need four values to set a bounding box.");
            Point one = Point.newBuilder().setLatitude(value.get(0)).setLongitude(value.get(1)).build();
            Point two = Point.newBuilder().setLatitude(value.get(2)).setLongitude(value.get(3)).build();
            this.bounds = BoundedBox.newBuilder().setCornerOne(one).setCornerTwo(two).build();
            return this;
        }

        public LocationView build() {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)this.locationId), (Object)"Location id cannot be blank");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)this.locationType), (Object)"Location type cannot be blank");
            Preconditions.checkArgument((!this.propertiesJsonNode.isNull() ? 1 : 0) != 0, (Object)"Properties jsonNode cannot be null");
            return new LocationView(this.locationId, this.locationType, this.propertiesJsonNode, Optional.fromNullable((Object)this.centroid), Optional.fromNullable((Object)this.bounds));
        }
    }
}

