/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.experiments;

import com.google.common.base.Preconditions;
import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestUtils;
import com.urbanairship.api.client.ResponseParser;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.entity.ContentType;

public class ExperimentDeleteRequest
implements Request<String> {
    private static final String DELETE_EXPERIMENT_PATH = "/api/experiments/scheduled/";
    private final String experimentId;

    private ExperimentDeleteRequest(String experimentId) {
        this.experimentId = experimentId;
    }

    public static ExperimentDeleteRequest newRequest(String experimentId) {
        Preconditions.checkNotNull((Object)experimentId, (Object)"Experiment Id may not be null");
        return new ExperimentDeleteRequest(experimentId);
    }

    @Override
    public ContentType getContentType() {
        return null;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/vnd.urbanairship+json; version=3");
        return headers;
    }

    @Override
    public Request.HttpMethod getHttpMethod() {
        return Request.HttpMethod.DELETE;
    }

    @Override
    public String getRequestBody() {
        return null;
    }

    @Override
    public URI getUri(URI baseUri) {
        String path = DELETE_EXPERIMENT_PATH + this.experimentId;
        return RequestUtils.resolveURI(baseUri, path);
    }

    @Override
    public ResponseParser<String> getResponseParser() {
        return new ResponseParser<String>(){

            @Override
            public String parse(String response) throws IOException {
                return response;
            }
        };
    }

    @Override
    public boolean bearerTokenAuthRequired() {
        return false;
    }
}

