/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.customevents.parse;

import com.fasterxml.jackson.core.JsonParser;
import com.urbanairship.api.common.parse.APIParsingException;
import com.urbanairship.api.common.parse.JsonObjectReader;
import com.urbanairship.api.common.parse.MapOfStringsDeserializer;
import com.urbanairship.api.common.parse.StringFieldDeserializer;
import com.urbanairship.api.customevents.model.CustomEventBody;
import java.io.IOException;

public class CustomEventBodyReader
implements JsonObjectReader<CustomEventBody> {
    private final CustomEventBody.Builder builder = CustomEventBody.newBuilder();

    public void readName(JsonParser parser) throws IOException {
        this.builder.setName(StringFieldDeserializer.INSTANCE.deserialize(parser, "name"));
    }

    public void readValue(JsonParser parser) throws IOException {
        this.builder.setValue(parser.getDecimalValue());
    }

    public void readTransaction(JsonParser parser) throws IOException {
        this.builder.setTransaction(StringFieldDeserializer.INSTANCE.deserialize(parser, "transaction"));
    }

    public void readInteractionId(JsonParser parser) throws IOException {
        this.builder.setInteractionId(StringFieldDeserializer.INSTANCE.deserialize(parser, "interaction_id"));
    }

    public void readInteractionType(JsonParser parser) throws IOException {
        this.builder.setInteractionType(StringFieldDeserializer.INSTANCE.deserialize(parser, "interaction_type"));
    }

    public void readProperties(JsonParser parser) throws IOException {
        this.builder.addAllPropertyEntries(MapOfStringsDeserializer.INSTANCE.deserialize(parser, "properties"));
    }

    public void readSessionId(JsonParser parser) throws IOException {
        this.builder.setSessionId(StringFieldDeserializer.INSTANCE.deserialize(parser, "session_id"));
    }

    @Override
    public CustomEventBody validateAndBuild() throws IOException {
        try {
            return this.builder.build();
        }
        catch (Exception e) {
            throw new APIParsingException(e.getMessage(), e);
        }
    }
}

