/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.client;

import com.google.common.base.Preconditions;
import org.apache.commons.lang.StringUtils;

public final class ProxyInfo {
    private final ProxyInfoProtocol protocol;
    private final String host;
    private final Integer port;
    private final String principal;
    private final String password;

    private ProxyInfo(Builder builder) {
        this.protocol = builder.protocol;
        this.host = builder.host;
        this.port = builder.port;
        this.principal = builder.principal;
        this.password = builder.password;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getProtocol() {
        return this.protocol.toString().toLowerCase();
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public String getPassword() {
        return this.password;
    }

    public String toString() {
        return "ProxyInfo{protocol='" + (Object)((Object)this.protocol) + '\'' + ", host='" + this.host + '\'' + ", port=" + this.port + ", principal=" + this.principal + ", password=" + this.password + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProxyInfo)) {
            return false;
        }
        ProxyInfo proxyInfo = (ProxyInfo)o;
        if (this.host != null ? !this.host.equals(proxyInfo.host) : proxyInfo.host != null) {
            return false;
        }
        if (this.password != null ? !this.password.equals(proxyInfo.password) : proxyInfo.password != null) {
            return false;
        }
        if (this.port != null ? !this.port.equals(proxyInfo.port) : proxyInfo.port != null) {
            return false;
        }
        if (this.principal != null ? !this.principal.equals(proxyInfo.principal) : proxyInfo.principal != null) {
            return false;
        }
        return !(this.protocol != null ? !this.protocol.equals((Object)proxyInfo.protocol) : proxyInfo.protocol != null);
    }

    public int hashCode() {
        int result = this.protocol != null ? this.protocol.hashCode() : 0;
        result = 31 * result + (this.host != null ? this.host.hashCode() : 0);
        result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
        result = 31 * result + (this.principal != null ? this.principal.hashCode() : 0);
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        return result;
    }

    public static enum ProxyInfoProtocol {
        HTTP,
        HTTPS;

    }

    public static class Builder {
        private ProxyInfoProtocol protocol = ProxyInfoProtocol.HTTPS;
        private String host;
        private int port = -1;
        private String principal = null;
        private String password = null;

        private Builder() {
        }

        public Builder setProtocol(ProxyInfoProtocol protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder setHost(String host) {
            this.host = host;
            return this;
        }

        public Builder setPort(int port) {
            this.port = port;
            return this;
        }

        public Builder setPrincipal(String principal) {
            this.principal = principal;
            return this;
        }

        public Builder setPassword(String password) {
            this.password = password;
            return this;
        }

        public ProxyInfo build() {
            Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)this.host), (Object)"Proxy host must be set.");
            Preconditions.checkNotNull((Object)((Object)this.protocol), (Object)"Proxy protocol must be set.");
            Preconditions.checkArgument((this.port > 0 ? 1 : 0) != 0, (Object)"Proxy port must be set.");
            return new ProxyInfo(this);
        }
    }
}

