/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.channel.model.web;

import com.google.common.base.Objects;
import com.google.common.base.Optional;

public final class Subscription {
    private final Optional<String> p256dh;
    private final Optional<String> auth;

    private Subscription(Optional<String> p256dh, Optional<String> auth) {
        this.p256dh = p256dh;
        this.auth = auth;
    }

    public Optional<String> getP256dh() {
        return this.p256dh;
    }

    public Optional<String> getAuth() {
        return this.auth;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Subscription that = (Subscription)o;
        return Objects.equal(this.p256dh, that.p256dh) && Objects.equal(this.auth, that.auth);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.p256dh, this.auth});
    }

    public String toString() {
        return "Subscription{p256dh=" + this.p256dh + ", auth=" + this.auth + '}';
    }

    public static final class Builder {
        private String p256dh = null;
        private String auth = null;

        private Builder() {
        }

        public Builder setP256dh(String p256dh) {
            this.p256dh = p256dh;
            return this;
        }

        public Builder setAuth(String auth) {
            this.auth = auth;
            return this;
        }

        public Subscription build() {
            return new Subscription(Optional.fromNullable((Object)this.p256dh), Optional.fromNullable((Object)this.auth));
        }
    }
}

