/*
 * Decompiled with CFR 0.152.
 */
package com.upyun.library.common;

import android.text.TextUtils;
import android.util.Log;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;

public class LogInterceptor
implements Interceptor {
    private static final String TAG = "HTTP_TRACE";
    private static final Charset UTF8 = Charset.forName("UTF-8");

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response response;
        Request request = chain.request();
        RequestBody requestBody = request.body();
        StringBuilder logBuilder = new StringBuilder();
        logBuilder.append("<---------------------------BEGIN REQUEST---------------------------------->");
        logBuilder.append("\n");
        logBuilder.append("Request encoded url: ").append(request.method()).append(" ").append(LogInterceptor.requestPath(request.url()));
        logBuilder.append("\n");
        String decodeUrl = this.requestDecodedPath(request.url());
        if (!TextUtils.isEmpty((CharSequence)decodeUrl)) {
            logBuilder.append("Request decoded url: ").append(request.method()).append(" ").append(decodeUrl);
        }
        Headers headers = request.headers();
        logBuilder.append("\n=============== Headers ===============\n");
        for (int i = headers.size() - 1; i > -1; --i) {
            logBuilder.append(headers.name(i)).append(" : ").append(headers.get(headers.name(i))).append("\n");
        }
        logBuilder.append("\n=============== END Headers ===============\n");
        if (requestBody != null) {
            Buffer buffer = new Buffer();
            requestBody.writeTo((BufferedSink)buffer);
            MediaType contentType = requestBody.contentType();
            if (contentType != null) {
                contentType.charset(UTF8);
            }
            if (requestBody.contentLength() < 1000L) {
                logBuilder.append(buffer.readString(UTF8));
            }
        }
        long startNs = System.nanoTime();
        try {
            response = chain.proceed(request);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)logBuilder.toString());
            throw e;
        }
        long tookMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
        ResponseBody responseBody = response.body();
        logBuilder.append("\n");
        logBuilder.append("Response timeout: ").append(tookMs).append("ms");
        logBuilder.append("\n");
        logBuilder.append("Response message: ").append(response.message());
        logBuilder.append("\n");
        logBuilder.append("Response code: ").append(response.code());
        if (responseBody != null) {
            BufferedSource source = responseBody.source();
            source.request(Long.MAX_VALUE);
            Buffer buffer = source.buffer();
            Charset charset = null;
            MediaType contentType = responseBody.contentType();
            if (contentType != null) {
                charset = contentType.charset(UTF8);
            }
            if (charset == null) {
                charset = UTF8;
            }
            if (responseBody.contentLength() != 0L) {
                logBuilder.append("\n");
                logBuilder.append("Response body: \n").append(buffer.clone().readString(charset));
            }
        }
        headers = response.headers();
        logBuilder.append("\n=============== Headers ===============\n");
        for (int i = headers.size() - 1; i > -1; --i) {
            logBuilder.append(headers.name(i)).append(" : ").append(headers.get(headers.name(i))).append("\n");
        }
        logBuilder.append("\n=============== END Headers ===============\n");
        logBuilder.append("\n");
        logBuilder.append("<-----------------------------END REQUEST--------------------------------->");
        logBuilder.append("\n\n\n");
        Log.d((String)TAG, (String)logBuilder.toString());
        return response;
    }

    private String requestDecodedPath(HttpUrl url) {
        try {
            String path = URLDecoder.decode(url.encodedPath(), "UTF-8");
            String query = URLDecoder.decode(url.encodedQuery(), "UTF-8");
            return url.scheme() + "://" + url.host() + (query != null ? path + '?' + query : path);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String requestPath(HttpUrl url) {
        String path = url.encodedPath();
        String query = url.encodedQuery();
        return url.scheme() + "://" + url.host() + (query != null ? path + '?' + query : path);
    }
}

