/*
 * Decompiled with CFR 0.152.
 */
package com.upyun.library.common;

import com.upyun.library.common.BlockUploader;
import com.upyun.library.common.FormUploader;
import com.upyun.library.common.UpConfig;
import com.upyun.library.common.UploadClient;
import com.upyun.library.listener.SignatureListener;
import com.upyun.library.listener.UpCompleteListener;
import com.upyun.library.listener.UpProgressListener;
import com.upyun.library.utils.AsyncRun;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@Deprecated
public class UploadManager {
    private static UploadManager instance;
    private ExecutorService executor = Executors.newFixedThreadPool(UpConfig.CONCURRENCY);
    private UploadClient upLoaderClient = new UploadClient();

    private UploadManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UploadManager getInstance() {
        if (instance != null) return instance;
        Class<UploadManager> clazz = UploadManager.class;
        synchronized (UploadManager.class) {
            if (instance != null) return instance;
            instance = new UploadManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    protected void upload(File file, Map<String, Object> params, String apiKey, UpCompleteListener completeListener, UpProgressListener progressListener) {
        this.upload(file, params, apiKey, null, completeListener, progressListener);
    }

    protected void upload(File file, Map<String, Object> params, SignatureListener signatureListener, UpCompleteListener completeListener, UpProgressListener progressListener) {
        this.upload(file, params, null, signatureListener, completeListener, progressListener);
    }

    public void formUpload(File file, Map<String, Object> params, String apiKey, UpCompleteListener completeListener, UpProgressListener progressListener) {
        this.upload(UploadType.FORM, file, params, apiKey, null, completeListener, progressListener);
    }

    public void formUpload(File file, Map<String, Object> params, SignatureListener signatureListener, UpCompleteListener completeListener, UpProgressListener progressListener) {
        this.upload(UploadType.FORM, file, params, null, signatureListener, completeListener, progressListener);
    }

    public void blockUpload(File file, Map<String, Object> params, String apiKey, UpCompleteListener completeListener, UpProgressListener progressListener) {
        this.upload(UploadType.BLOCK, file, params, apiKey, null, completeListener, progressListener);
    }

    public void blockUpload(File file, Map<String, Object> params, SignatureListener signatureListener, UpCompleteListener completeListener, UpProgressListener progressListener) {
        this.upload(UploadType.BLOCK, file, params, null, signatureListener, completeListener, progressListener);
    }

    protected void upload(UploadType type, File file, Map<String, Object> params, String apiKey, SignatureListener signatureListener, final UpCompleteListener completeListener, final UpProgressListener progressListener) {
        if (file == null) {
            completeListener.onComplete(false, "\u6587\u4ef6\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
            return;
        }
        if (params == null) {
            completeListener.onComplete(false, "\u53c2\u6570\u4e0d\u53ef\u4e3a\u7a7a");
            return;
        }
        if (apiKey == null && signatureListener == null) {
            completeListener.onComplete(false, "APIkey\u548csignatureListener\u4e0d\u53ef\u540c\u65f6\u4e3anull");
            return;
        }
        if (completeListener == null) {
            throw new RuntimeException("completeListener \u4e0d\u53ef\u4e3anull");
        }
        if (params.get("bucket") == null) {
            params.put("bucket", UpConfig.BUCKET);
        }
        if (params.get("expiration") == null) {
            params.put("expiration", System.currentTimeMillis() / 1000L + UpConfig.EXPIRATION);
        }
        UpProgressListener uiProgressListener = new UpProgressListener(){

            @Override
            public void onRequestProgress(final long bytesWrite, final long contentLength) {
                AsyncRun.run(new Runnable(){

                    @Override
                    public void run() {
                        if (progressListener != null) {
                            progressListener.onRequestProgress(bytesWrite, contentLength);
                        }
                    }
                });
            }
        };
        UpCompleteListener uiCompleteListener = new UpCompleteListener(){

            @Override
            public void onComplete(final boolean isSuccess, final String result) {
                AsyncRun.run(new Runnable(){

                    @Override
                    public void run() {
                        completeListener.onComplete(isSuccess, result);
                    }
                });
            }
        };
        HashMap<String, Object> localParams = new HashMap<String, Object>();
        localParams.putAll(params);
        Runnable uploadRunnable = null;
        switch (type) {
            case FORM: {
                uploadRunnable = new FormUploader(this.upLoaderClient, file, localParams, apiKey, signatureListener, uiCompleteListener, uiProgressListener);
                break;
            }
            case BLOCK: {
                uploadRunnable = new BlockUploader(this.upLoaderClient, file, localParams, apiKey, signatureListener, uiCompleteListener, uiProgressListener);
            }
        }
        this.executor.execute(uploadRunnable);
    }

    protected void upload(File file, Map<String, Object> params, String apiKey, SignatureListener signatureListener, UpCompleteListener completeListener, UpProgressListener progressListener) {
        if (file.length() < UpConfig.FILE_BOUND) {
            this.upload(UploadType.FORM, file, params, apiKey, signatureListener, completeListener, progressListener);
        } else {
            this.upload(UploadType.BLOCK, file, params, apiKey, signatureListener, completeListener, progressListener);
        }
    }

    static enum UploadType {
        FORM,
        BLOCK;

    }
}

