/*
 * Decompiled with CFR 0.152.
 */
package com.upyun.library.common;

import com.upyun.library.common.BaseUploader;
import com.upyun.library.exception.UpYunException;
import com.upyun.library.utils.UpYunUtils;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class ParallelUploader
extends BaseUploader {
    private volatile int blockProgress;
    private int parallel = 4;
    private int[] status;

    public void setParallel(int parallel) {
        this.parallel = parallel;
    }

    public boolean resume(String uuid, int[] status) throws IOException, UpYunException {
        this.uuid = uuid;
        this.status = status;
        if (uuid == null || status == null || status.length != this.totalBlock - 2) {
            throw new UpYunException("uuid or status is wrong, please restart!");
        }
        this.paused = false;
        return this.startUpload();
    }

    public ParallelUploader(String bucketName, String userName, String password) {
        super(bucketName, userName, password);
    }

    public ParallelUploader() {
    }

    @Override
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public boolean upload(File file, String uploadPath, Map<String, String> params) throws IOException, UpYunException {
        this.init(file, uploadPath, params);
        if (this.status == null || this.status.length != this.totalBlock - 2 || this.uuid == null) {
            this.status = new int[this.totalBlock - 2];
        }
        this.params.put("X-Upyun-Multi-Disorder", "true");
        return this.startUpload();
    }

    @Override
    public boolean upload(File file, String uri, String date, String signature, Map<String, String> params) throws IOException, UpYunException {
        this.init(file, uri, date, signature, params);
        if (this.status == null || this.status.length != this.totalBlock - 2 || this.uuid == null) {
            this.status = new int[this.totalBlock - 2];
        }
        this.params.put("X-Upyun-Multi-Disorder", "true");
        return this.startUpload();
    }

    public int[] getStatus() {
        return this.status;
    }

    public void setStatus(int[] status) {
        this.status = status;
    }

    @Override
    boolean processUpload() throws IOException, UpYunException {
        this.blockProgress = 0;
        ExecutorService uploadExecutor = Executors.newFixedThreadPool(this.parallel);
        for (int i = 0; i < this.totalBlock - 2; ++i) {
            Future<?> future = uploadExecutor.submit(this.uploadBlock(i));
            try {
                future.get();
                continue;
            }
            catch (Exception e) {
                uploadExecutor.shutdown();
                if (this.randomAccessFile != null) {
                    this.randomAccessFile.close();
                    this.randomAccessFile = null;
                }
                throw new UpYunException(e.getMessage());
            }
        }
        uploadExecutor.shutdown();
        try {
            uploadExecutor.awaitTermination(Long.MAX_VALUE, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return this.completeUpload();
    }

    private Runnable uploadBlock(final int index) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    if (ParallelUploader.this.paused) {
                        throw new UpYunException("upload paused");
                    }
                    if (ParallelUploader.this.status[index] == 1) {
                        if (ParallelUploader.this.onProgressListener != null) {
                            ParallelUploader.this.onProgressListener.onRequestProgress(ParallelUploader.this.blockProgress + 2, ParallelUploader.this.totalBlock);
                        }
                        ParallelUploader.this.blockProgress++;
                        return;
                    }
                    if (ParallelUploader.this.status[index] == 2) {
                        return;
                    }
                    ((ParallelUploader)ParallelUploader.this).status[index] = 2;
                    byte[] data = ParallelUploader.this.readBlockByIndex(index);
                    RequestBody requestBody = RequestBody.create(null, (byte[])data);
                    String md5 = null;
                    if (ParallelUploader.this.checkMD5) {
                        md5 = UpYunUtils.md5(data);
                    }
                    if (!ParallelUploader.this.signed) {
                        ParallelUploader.this.date = ParallelUploader.this.getGMTDate();
                        ParallelUploader.this.signature = UpYunUtils.sign("PUT", ParallelUploader.this.date, ParallelUploader.this.uri, ParallelUploader.this.userName, ParallelUploader.this.password, md5).trim();
                    }
                    Request.Builder builder = new Request.Builder().url(ParallelUploader.this.url).header("Date", ParallelUploader.this.date).header("Authorization", ParallelUploader.this.signature).header("X-Upyun-Multi-Stage", "upload").header("X-Upyun-Multi-UUID", ParallelUploader.this.uuid).header("X-Upyun-Part-ID", index + "").header("User-Agent", "upyun-android-sdk 2.1.0").put(requestBody);
                    if (md5 != null) {
                        builder.header("Content-MD5", md5);
                    }
                    Response response = ParallelUploader.this.uploadRequest(builder);
                    ParallelUploader.this.uuid = response.header("X-Upyun-Multi-UUID", "");
                    ((ParallelUploader)ParallelUploader.this).status[index] = 1;
                }
                catch (Exception e) {
                    ((ParallelUploader)ParallelUploader.this).status[index] = 3;
                    throw new RuntimeException(e.getMessage());
                }
            }
        };
    }

    private Response uploadRequest(Request.Builder builder) {
        try {
            Response response = this.mClient.newCall(builder.build()).execute();
            if (!response.isSuccessful()) {
                this.uuid = null;
                throw new RuntimeException(response.body().string());
            }
            if (this.onProgressListener != null) {
                this.onProgressListener.onRequestProgress(this.blockProgress + 2, this.totalBlock);
            }
            ++this.blockProgress;
            return response;
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
    }

    @Override
    boolean completeUpload() throws IOException, UpYunException {
        this.completeRequest();
        this.status = null;
        this.uuid = null;
        return true;
    }
}

