/*
 * Decompiled with CFR 0.152.
 */
package com.upyun.library.common;

import com.upyun.library.exception.UpYunException;
import com.upyun.library.listener.UpCompleteListener;
import com.upyun.library.listener.UpProgressListener;
import com.upyun.library.utils.AsyncRun;
import com.upyun.library.utils.Base64Coder;
import com.upyun.library.utils.UpYunUtils;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public abstract class BaseUploader {
    static final String AUTHORIZATION = "Authorization";
    static final String BACKSLASH = "/";
    static final int BLOCK_SIZE = 0x100000;
    final String DATE = "Date";
    static final String CONTENT_MD5 = "Content-MD5";
    static final String CONTENT_TYPE = "CContent-Type";
    static final String CONTENT_SECRET = "Content-Secret";
    static final String X_Upyun_Meta_X = "X-Upyun-Meta-X";
    static final String X_UPYUN_MULTI_DISORDER = "X-Upyun-Multi-Disorder";
    static final String X_UPYUN_MULTI_STAGE = "X-Upyun-Multi-Stage";
    static final String X_UPYUN_MULTI_TYPE = "X-Upyun-Multi-Type";
    static final String X_UPYUN_MULTI_LENGTH = "X-Upyun-Multi-Length";
    static final String X_UPYUN_MULTI_UUID = "X-Upyun-Multi-UUID";
    static final String X_UPYUN_PART_ID = "X-Upyun-Part-ID";
    static final String X_UPYUN_NEXT_PART_ID = "X-Upyun-Next-Part-ID";
    static final String HOST = "https://v0.api.upyun.com";
    ExecutorService executorService = Executors.newSingleThreadExecutor();
    Map<String, String> params;
    volatile boolean paused;
    boolean signed;
    String uuid;
    String uri;
    OkHttpClient mClient;
    File mFile;
    RandomAccessFile randomAccessFile;
    boolean checkMD5;
    String bucketName;
    String userName;
    String password;
    int timeout = 20;
    String url;
    UpProgressListener onProgressListener;
    int totalBlock;
    String date = null;
    String signature = null;

    public boolean resume() throws IOException, UpYunException {
        this.paused = false;
        return this.startUpload();
    }

    public BaseUploader(String bucketName, String userName, String password) {
        this.bucketName = bucketName;
        this.userName = userName;
        this.password = password;
    }

    public BaseUploader() {
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void pause() {
        this.paused = true;
    }

    void init(File file, String uploadPath, Map<String, String> params) {
        this.signed = false;
        this.paused = false;
        if (params == null) {
            params = new HashMap<String, String>();
        }
        this.params = params;
        this.mFile = file;
        this.totalBlock = (int)Math.ceil((double)this.mFile.length() / 1048576.0 + 2.0);
        this.uri = uploadPath.startsWith(BACKSLASH) ? BACKSLASH + this.bucketName + BACKSLASH + URLEncoder.encode(uploadPath.substring(1)) : BACKSLASH + this.bucketName + BACKSLASH + URLEncoder.encode(uploadPath);
        this.url = HOST + this.uri;
        this.mClient = new OkHttpClient.Builder().connectTimeout((long)this.timeout, TimeUnit.SECONDS).readTimeout((long)this.timeout, TimeUnit.SECONDS).writeTimeout((long)this.timeout, TimeUnit.SECONDS).build();
    }

    void init(File file, String uri, String date, String signature, Map<String, String> params) {
        this.signed = true;
        this.uri = uri;
        this.signature = signature;
        this.paused = false;
        if (params == null) {
            params = new HashMap<String, String>();
        }
        this.params = params;
        this.mFile = file;
        this.date = date;
        this.totalBlock = (int)Math.ceil((double)this.mFile.length() / 1048576.0 + 2.0);
        this.url = HOST + uri;
        this.mClient = new OkHttpClient.Builder().connectTimeout((long)this.timeout, TimeUnit.SECONDS).readTimeout((long)this.timeout, TimeUnit.SECONDS).writeTimeout((long)this.timeout, TimeUnit.SECONDS).build();
    }

    abstract boolean upload(File var1, String var2, Map<String, String> var3) throws IOException, UpYunException;

    abstract boolean upload(File var1, String var2, String var3, String var4, Map<String, String> var5) throws IOException, UpYunException, ExecutionException, InterruptedException;

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public void setCheckMD5(boolean checkMD5) {
        this.checkMD5 = checkMD5;
    }

    public void setOnProgressListener(UpProgressListener onProgressListener) {
        this.onProgressListener = onProgressListener;
    }

    boolean startUpload() throws IOException, UpYunException {
        if (this.paused) {
            throw new UpYunException("upload paused");
        }
        if (this.uuid == null) {
            RequestBody requestBody = RequestBody.create(null, (String)"");
            String md5 = null;
            if (this.checkMD5) {
                md5 = UpYunUtils.md5("");
            }
            if (!this.signed) {
                this.date = this.getGMTDate();
                this.signature = UpYunUtils.sign("PUT", this.date, this.uri, this.userName, this.password, md5).trim();
            }
            Request.Builder builder = new Request.Builder().url(this.url).header("Date", this.date).header(AUTHORIZATION, this.signature).header(X_UPYUN_MULTI_STAGE, "initiate").header(X_UPYUN_MULTI_TYPE, "application/octet-stream").header(X_UPYUN_MULTI_LENGTH, this.mFile.length() + "").header("User-Agent", "upyun-android-sdk 2.1.0").put(requestBody);
            if (this.params != null) {
                for (Map.Entry<String, String> entry : this.params.entrySet()) {
                    builder.header(entry.getKey(), entry.getValue());
                }
            }
            if (md5 != null) {
                builder.header(CONTENT_MD5, md5);
            }
            this.callRequest(builder.build(), 1);
        }
        if (this.randomAccessFile == null) {
            this.randomAccessFile = new RandomAccessFile(this.mFile, "r");
        }
        return this.processUpload();
    }

    abstract boolean processUpload() throws IOException, UpYunException;

    abstract boolean completeUpload() throws IOException, UpYunException;

    void completeRequest() throws UpYunException, IOException {
        if (this.randomAccessFile != null) {
            this.randomAccessFile.close();
            this.randomAccessFile = null;
        }
        RequestBody requestBody = RequestBody.create(null, (String)"");
        String md5 = null;
        if (this.checkMD5) {
            md5 = UpYunUtils.md5("");
        }
        if (!this.signed) {
            this.date = this.getGMTDate();
            this.signature = UpYunUtils.sign("PUT", this.date, this.uri, this.userName, this.password, md5).trim();
        }
        Request.Builder builder = new Request.Builder().url(this.url).header("Date", this.date).header(AUTHORIZATION, this.signature).header(X_UPYUN_MULTI_STAGE, "complete").header(X_UPYUN_MULTI_UUID, this.uuid).header("User-Agent", "upyun-android-sdk 2.1.0").put(requestBody);
        if (md5 != null) {
            builder.header(CONTENT_MD5, md5);
        }
        this.callRequest(builder.build(), this.totalBlock);
    }

    Response callRequest(Request request, int index) throws IOException, UpYunException {
        Response response = this.mClient.newCall(request).execute();
        if (!response.isSuccessful()) {
            this.uuid = null;
            throw new UpYunException(response.body().string());
        }
        if (this.onProgressListener != null) {
            this.onProgressListener.onRequestProgress(index, this.totalBlock);
        }
        this.uuid = response.header(X_UPYUN_MULTI_UUID, "");
        return response;
    }

    String getGMTDate() {
        SimpleDateFormat formater = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        formater.setTimeZone(TimeZone.getTimeZone("GMT"));
        return formater.format(new Date());
    }

    byte[] readBlockByIndex(int index) throws IOException {
        byte[] block = new byte[0x100000];
        int readedSize = 0;
        int offset = index * 0x100000;
        this.randomAccessFile.seek(offset);
        readedSize = this.randomAccessFile.read(block, 0, 0x100000);
        if (readedSize < 0x100000) {
            byte[] notFullBlock = new byte[readedSize];
            System.arraycopy(block, 0, notFullBlock, 0, readedSize);
            return notFullBlock;
        }
        return block;
    }

    public void upload(final File file, final String uploadPath, final Map<String, String> restParams, final Map<String, Object> processParam, final UpCompleteListener completeListener) {
        if (processParam == null) {
            this.upload(file, uploadPath, restParams, completeListener);
            return;
        }
        final UpCompleteListener uiCompleteListener = new UpCompleteListener(){

            @Override
            public void onComplete(final boolean isSuccess, final String result) {
                AsyncRun.run(new Runnable(){

                    @Override
                    public void run() {
                        if (completeListener != null) {
                            completeListener.onComplete(isSuccess, result);
                        }
                    }
                });
            }
        };
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    BaseUploader.this.upload(file, uploadPath, restParams);
                    String date = BaseUploader.this.getGMTDate();
                    String sign = UpYunUtils.sign("POST", date, "/pretreatment/", BaseUploader.this.userName, BaseUploader.this.password, null);
                    processParam.put("tasks", Base64Coder.encodeString(processParam.get("tasks").toString()));
                    FormBody.Builder builder = new FormBody.Builder();
                    for (Map.Entry mapping : processParam.entrySet()) {
                        builder.addEncoded((String)mapping.getKey(), mapping.getValue().toString());
                    }
                    String processURL = "http://p0.api.upyun.com/pretreatment/";
                    Request request = new Request.Builder().url(processURL).post((RequestBody)builder.build()).header("Date", date).header(BaseUploader.AUTHORIZATION, sign).header("User-Agent", "upyun-android-sdk 2.1.0").build();
                    Response response = BaseUploader.this.mClient.newCall(request).execute();
                    if (!response.isSuccessful()) {
                        uiCompleteListener.onComplete(false, response.body().string());
                    } else {
                        uiCompleteListener.onComplete(true, response.body().string());
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    uiCompleteListener.onComplete(false, e.toString());
                }
                catch (UpYunException e) {
                    e.printStackTrace();
                    uiCompleteListener.onComplete(false, e.toString());
                }
            }
        });
    }

    public void upload(final File file, final String uploadPath, final Map<String, String> restParams, final UpCompleteListener completeListener) {
        final UpCompleteListener uiCompleteListener = new UpCompleteListener(){

            @Override
            public void onComplete(final boolean isSuccess, final String result) {
                AsyncRun.run(new Runnable(){

                    @Override
                    public void run() {
                        if (completeListener != null) {
                            completeListener.onComplete(isSuccess, result);
                        }
                    }
                });
            }
        };
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    BaseUploader.this.upload(file, uploadPath, restParams);
                    uiCompleteListener.onComplete(true, null);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    uiCompleteListener.onComplete(false, e.toString());
                }
                catch (UpYunException e) {
                    e.printStackTrace();
                    uiCompleteListener.onComplete(false, e.toString());
                }
            }
        });
    }

    public void upload(final File file, final String uri, final String date, final String signature, final Map<String, String> restParams, final UpCompleteListener completeListener) {
        final UpCompleteListener uiCompleteListener = new UpCompleteListener(){

            @Override
            public void onComplete(final boolean isSuccess, final String result) {
                AsyncRun.run(new Runnable(){

                    @Override
                    public void run() {
                        if (completeListener != null) {
                            completeListener.onComplete(isSuccess, result);
                        }
                    }
                });
            }
        };
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    BaseUploader.this.upload(file, uri, date, signature, restParams);
                    uiCompleteListener.onComplete(true, null);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    uiCompleteListener.onComplete(false, e.toString());
                }
                catch (UpYunException e) {
                    e.printStackTrace();
                    uiCompleteListener.onComplete(false, e.toString());
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    uiCompleteListener.onComplete(false, e.toString());
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                    uiCompleteListener.onComplete(false, e.toString());
                }
            }
        });
    }

    public class Params {
        public static final String BUCKET_NAME = "bucket_name";
        public static final String NOTIFY_URL = "notify_url";
        public static final String SOURCE = "source";
        public static final String TASKS = "tasks";
        public static final String ACCEPT = "accept";
        public static final String STATUS_CODE = "status_code";
        public static final String PATH = "path";
        public static final String DESCRIPTION = "description";
        public static final String TASK_ID = "task_id";
        public static final String INFO = "info";
        public static final String SIGNATURE = "signature";
        public static final String TIMESTAMP = "timestamp";
        public static final String TASK_IDS = "task_ids";
        public static final String TYPE = "type";
        public static final String SAVE_AS = "save_as";
        public static final String RETURN_INFO = "return_info";
        public static final String AVOPTS = "avopts";
    }
}

