/*
 * Decompiled with CFR 0.152.
 */
package com.upyun.library.utils;

import com.upyun.library.common.UpConfig;
import com.upyun.library.utils.Base64Coder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.Arrays;
import java.util.Formatter;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.json.JSONObject;

public class UpYunUtils {
    private static final String HMAC_SHA1_ALGORITHM = "HmacSHA1";
    public static final String VERSION = "upyun-android-sdk 2.0.9";

    public static String getPolicy(Map<String, Object> paramMap) {
        JSONObject obj = new JSONObject(paramMap);
        return Base64Coder.encodeString(obj.toString());
    }

    public static String getSignature(String policy, String secretKey) {
        return UpYunUtils.md5(policy + "&" + secretKey);
    }

    public static String getSignature(Map<String, Object> paramMap, String secretKey) {
        Object[] keys = paramMap.keySet().toArray();
        Arrays.sort(keys);
        StringBuffer tmp = new StringBuffer("");
        for (Object key : keys) {
            tmp.append(key).append(paramMap.get(key));
        }
        tmp.append(secretKey);
        return UpYunUtils.md5(tmp.toString().getBytes());
    }

    public static String md5(byte[] bytes) {
        byte[] hash;
        try {
            hash = MessageDigest.getInstance("MD5").digest(bytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("MessageDigest\u4e0d\u652f\u6301MD5Util", e);
        }
        StringBuilder hex = new StringBuilder(hash.length * 2);
        for (byte b : hash) {
            if ((b & 0xFF) < 16) {
                hex.append("0");
            }
            hex.append(Integer.toHexString(b & 0xFF));
        }
        return hex.toString();
    }

    public static String md5(String string) {
        byte[] hash;
        try {
            hash = MessageDigest.getInstance("MD5").digest(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 is unsupported", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("MessageDigest\u4e0d\u652f\u6301MD5Util", e);
        }
        StringBuilder hex = new StringBuilder(hash.length * 2);
        for (byte b : hash) {
            if ((b & 0xFF) < 16) {
                hex.append("0");
            }
            hex.append(Integer.toHexString(b & 0xFF));
        }
        return hex.toString();
    }

    public static String md5Hex(File file) {
        try {
            int length;
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            FileInputStream in = new FileInputStream(file);
            byte[] buffer = new byte[UpConfig.BLOCK_SIZE];
            while ((length = in.read(buffer)) > 0) {
                messageDigest.update(buffer, 0, length);
            }
            byte[] hash = messageDigest.digest();
            StringBuilder hex = new StringBuilder(hash.length * 2);
            for (byte b : hash) {
                if ((b & 0xFF) < 16) {
                    hex.append("0");
                }
                hex.append(Integer.toHexString(b & 0xFF));
            }
            return hex.toString();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("file not found", e);
        }
        catch (IOException e) {
            throw new RuntimeException("file get md5 failed", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("MessageDigest\u4e0d\u652f\u6301MD5Util", e);
        }
    }

    public static String md5(File file, int blockSize) {
        try {
            int length;
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            FileInputStream in = new FileInputStream(file);
            byte[] buffer = new byte[blockSize];
            while ((length = in.read(buffer)) > 0) {
                messageDigest.update(buffer, 0, length);
            }
            byte[] hash = messageDigest.digest();
            StringBuilder hex = new StringBuilder(hash.length * 2);
            for (byte b : hash) {
                if ((b & 0xFF) < 16) {
                    hex.append("0");
                }
                hex.append(Integer.toHexString(b & 0xFF));
            }
            return hex.toString();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("file not found", e);
        }
        catch (IOException e) {
            throw new RuntimeException("file get md5 failed", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("MessageDigest\u4e0d\u652f\u6301MD5Util", e);
        }
    }

    public static int getBlockNum(File file, int blockSize) {
        return (int)Math.ceil((double)file.length() / (double)blockSize);
    }

    private static String toHexString(byte[] bytes) {
        Formatter formatter = new Formatter();
        for (byte b : bytes) {
            formatter.format("%02x", b);
        }
        return formatter.toString();
    }

    public static String calculateRFC2104HMAC(String key, String data) throws SignatureException, NoSuchAlgorithmException, InvalidKeyException {
        SecretKeySpec signingKey = new SecretKeySpec(key.getBytes(), HMAC_SHA1_ALGORITHM);
        Mac mac = Mac.getInstance(HMAC_SHA1_ALGORITHM);
        mac.init(signingKey);
        return UpYunUtils.toHexString(mac.doFinal(data.getBytes()));
    }

    public static byte[] calculateRFC2104HMACRaw(String key, String data) throws SignatureException, NoSuchAlgorithmException, InvalidKeyException {
        byte[] keyBytes = key.getBytes();
        SecretKeySpec signingKey = new SecretKeySpec(keyBytes, HMAC_SHA1_ALGORITHM);
        Mac mac = Mac.getInstance(HMAC_SHA1_ALGORITHM);
        mac.init(signingKey);
        return mac.doFinal(data.getBytes());
    }
}

