/*
 * Decompiled with CFR 0.152.
 */
package com.upyun.library.common;

import com.upyun.library.common.PostData;
import com.upyun.library.common.ProgressHelper;
import com.upyun.library.common.UpConfig;
import com.upyun.library.exception.RespException;
import com.upyun.library.listener.UpProgressListener;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.FormBody;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class UploadClient {
    private static final String TAG = "UploadClient";
    private OkHttpClient client = new OkHttpClient.Builder().connectTimeout((long)UpConfig.CONNECT_TIMEOUT, TimeUnit.SECONDS).readTimeout((long)UpConfig.READ_TIMEOUT, TimeUnit.SECONDS).writeTimeout((long)UpConfig.WRITE_TIMEOUT, TimeUnit.SECONDS).followRedirects(true).build();

    public String fromUpLoad2(File file, String url, String policy, String operator, String signature, UpProgressListener listener) throws IOException, RespException {
        Request request;
        Response response;
        Object requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("policy", policy).addFormDataPart("authorization", "UPYUN " + operator + ":" + signature).addFormDataPart("file", file.getName(), RequestBody.create(null, (File)file)).build();
        if (listener != null) {
            requestBody = ProgressHelper.addProgressListener((RequestBody)requestBody, listener);
        }
        if (!(response = this.client.newCall(request = new Request.Builder().addHeader("x-upyun-api-version", "2").header("User-Agent", "upyun-android-sdk 2.0.6").url(url).post((RequestBody)requestBody).build()).execute()).isSuccessful()) {
            throw new RespException(response.code(), response.body().string());
        }
        return response.body().string();
    }

    public String fromUpLoad(File file, String url, String policy, String signature, UpProgressListener listener) throws IOException, RespException {
        Request request;
        Response response;
        Object requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("policy", policy).addFormDataPart("signature", signature).addFormDataPart("file", file.getName(), RequestBody.create(null, (File)file)).build();
        if (listener != null) {
            requestBody = ProgressHelper.addProgressListener((RequestBody)requestBody, listener);
        }
        if (!(response = this.client.newCall(request = new Request.Builder().addHeader("x-upyun-api-version", "2").header("User-Agent", "upyun-android-sdk 2.0.6").url(url).post((RequestBody)requestBody).build()).execute()).isSuccessful()) {
            throw new RespException(response.code(), response.body().string());
        }
        return response.body().string();
    }

    public String post(String url, Map<String, String> requestParams) throws IOException, RespException {
        FormBody.Builder builder = new FormBody.Builder();
        for (Map.Entry<String, String> entry : requestParams.entrySet()) {
            builder.add(entry.getKey(), entry.getValue());
        }
        Request request = new Request.Builder().addHeader("x-upyun-api-version", "2").header("User-Agent", "upyun-android-sdk 2.0.6").url(url).post((RequestBody)builder.build()).build();
        Response response = this.client.newCall(request).execute();
        if (!response.isSuccessful()) {
            throw new RespException(response.code(), response.body().string());
        }
        return response.body().string();
    }

    public String blockMultipartPost(String url, PostData postData) throws IOException, RespException {
        Map<String, String> requestParams = postData.params;
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        for (Map.Entry<String, String> entry : requestParams.entrySet()) {
            builder.addFormDataPart(entry.getKey(), entry.getValue());
        }
        builder.addFormDataPart("file", postData.fileName, RequestBody.create(null, (byte[])postData.data));
        Request request = new Request.Builder().addHeader("x-upyun-api-version", "2").header("User-Agent", "upyun-android-sdk 2.0.6").url(url).post((RequestBody)builder.build()).build();
        Response response = this.client.newCall(request).execute();
        if (!response.isSuccessful()) {
            throw new RespException(response.code(), response.body().string());
        }
        return response.body().string();
    }
}

