/*
 * Decompiled with CFR 0.152.
 */
package com.upyun.library.common;

import android.util.Log;
import com.upyun.library.exception.UpYunException;
import com.upyun.library.listener.UpCompleteListener;
import com.upyun.library.listener.UpProgressListener;
import com.upyun.library.utils.AsyncRun;
import com.upyun.library.utils.Base64Coder;
import com.upyun.library.utils.UpYunUtils;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class ResumeUploader {
    private static final String AUTHORIZATION = "Authorization";
    private static final int BLOCK_SIZE = 0x100000;
    private final String DATE = "Date";
    private static final String CONTENT_MD5 = "Content-MD5";
    private static final String CONTENT_TYPE = "CContent-Type";
    private static final String CONTENT_SECRET = "Content-Secret";
    private static final String X_Upyun_Meta_X = "X-Upyun-Meta-X";
    private static final String X_UPYUN_MULTI_STAGE = "X-Upyun-Multi-Stage";
    private static final String X_UPYUN_MULTI_TYPE = "X-Upyun-Multi-Type";
    private static final String X_UPYUN_MULTI_LENGTH = "X-Upyun-Multi-Length";
    private static final String X_UPYUN_META_X = "X-Upyun-Meta-X";
    private static final String X_UPYUN_MULTI_UUID = "X-Upyun-Multi-UUID";
    private static final String X_UPYUN_PART_ID = "X-Upyun-Part-ID";
    private static final String X_UPYUN_NEXT_PART_ID = "X-Upyun-Next-Part-ID";
    private static final String HOST = "http://v0.api.upyun.com";
    private String uuid;
    private String uploadPath;
    private OkHttpClient mClient;
    private File mFile;
    private int nextPartIndex;
    private RandomAccessFile randomAccessFile;
    private boolean checkMD5;
    protected String bucketName = null;
    protected String userName = null;
    protected String password = null;
    private int timeout = 20;
    private String url;
    private Call currentCall;
    private UpProgressListener onProgressListener;
    private OnInterruptListener onInterruptListener;
    private int totalBlock;
    private ExecutorService executorService = Executors.newSingleThreadExecutor();

    public boolean resume() throws IOException, UpYunException {
        if (this.uuid == null) {
            throw new UpYunException("uuid is null, please restart!");
        }
        return this.processUpload();
    }

    public boolean resume(String uuid, int newxtPartIndex) throws IOException, UpYunException {
        this.uuid = uuid;
        this.nextPartIndex = newxtPartIndex;
        if (uuid == null) {
            throw new UpYunException("uuid is null, please restart!");
        }
        return this.processUpload();
    }

    public ResumeUploader(String bucketName, String userName, String password) {
        this.bucketName = bucketName;
        this.userName = userName;
        this.password = password;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public boolean upload(File file, String uploadPath, Map<String, String> params) throws IOException, UpYunException {
        this.mFile = file;
        this.totalBlock = (int)Math.ceil((double)this.mFile.length() / 1048576.0 + 2.0);
        this.randomAccessFile = new RandomAccessFile(this.mFile, "r");
        this.uploadPath = uploadPath;
        this.url = "http://v0.api.upyun.com/" + this.bucketName + uploadPath;
        this.mClient = new OkHttpClient.Builder().connectTimeout((long)this.timeout, TimeUnit.SECONDS).readTimeout((long)this.timeout, TimeUnit.SECONDS).writeTimeout((long)this.timeout, TimeUnit.SECONDS).build();
        return this.startUpload(params);
    }

    public void upload(final File file, final String uploadPath, final Map<String, String> restParams, final Map<String, Object> processParam, final UpCompleteListener completeListener) {
        if (processParam == null) {
            this.upload(file, uploadPath, restParams, completeListener);
            return;
        }
        final UpCompleteListener uiCompleteListener = new UpCompleteListener(){

            @Override
            public void onComplete(final boolean isSuccess, final String result) {
                AsyncRun.run(new Runnable(){

                    @Override
                    public void run() {
                        if (completeListener != null) {
                            completeListener.onComplete(isSuccess, result);
                        }
                    }
                });
            }
        };
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ResumeUploader.this.upload(file, uploadPath, restParams);
                    String date = ResumeUploader.this.getGMTDate();
                    String sign = ResumeUploader.this.sign("POST", date, "/pretreatment/", ResumeUploader.this.userName, ResumeUploader.this.password, null);
                    processParam.put("tasks", Base64Coder.encodeString(processParam.get("tasks").toString()));
                    FormBody.Builder builder = new FormBody.Builder();
                    for (Map.Entry mapping : processParam.entrySet()) {
                        builder.addEncoded((String)mapping.getKey(), mapping.getValue().toString());
                    }
                    String processURL = "http://p0.api.upyun.com/pretreatment/";
                    Request request = new Request.Builder().url(processURL).post((RequestBody)builder.build()).header("Date", date).header(ResumeUploader.AUTHORIZATION, sign).header("User-Agent", "upyun-android-sdk 2.0.6").build();
                    Response response = ResumeUploader.this.mClient.newCall(request).execute();
                    if (!response.isSuccessful()) {
                        uiCompleteListener.onComplete(false, response.body().string());
                    } else {
                        uiCompleteListener.onComplete(true, response.body().string());
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    uiCompleteListener.onComplete(false, e.toString());
                }
                catch (UpYunException e) {
                    e.printStackTrace();
                    uiCompleteListener.onComplete(false, e.toString());
                }
            }
        });
    }

    public void upload(final File file, final String uploadPath, final Map<String, String> restParams, final UpCompleteListener completeListener) {
        final UpCompleteListener uiCompleteListener = new UpCompleteListener(){

            @Override
            public void onComplete(final boolean isSuccess, final String result) {
                AsyncRun.run(new Runnable(){

                    @Override
                    public void run() {
                        if (completeListener != null) {
                            completeListener.onComplete(isSuccess, result);
                        }
                    }
                });
            }
        };
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ResumeUploader.this.upload(file, uploadPath, restParams);
                    uiCompleteListener.onComplete(true, null);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    uiCompleteListener.onComplete(false, e.toString());
                }
                catch (UpYunException e) {
                    e.printStackTrace();
                    uiCompleteListener.onComplete(false, e.toString());
                }
            }
        });
    }

    public String getUuid() {
        return this.uuid;
    }

    public int getNextPartIndex() {
        return this.nextPartIndex;
    }

    public void setCheckMD5(boolean checkMD5) {
        this.checkMD5 = checkMD5;
    }

    public void setOnProgressListener(UpProgressListener onProgressListener) {
        this.onProgressListener = onProgressListener;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public void setNextPartIndex(int nextPartIndex) {
        this.nextPartIndex = nextPartIndex;
    }

    private boolean startUpload(Map<String, String> params) throws IOException, UpYunException {
        if (this.uuid != null) {
            return this.processUpload();
        }
        RequestBody requestBody = RequestBody.create(null, (String)"");
        String date = this.getGMTDate();
        String md5 = null;
        if (this.checkMD5) {
            md5 = UpYunUtils.md5("");
        }
        String sign = this.sign("PUT", date, "/" + this.bucketName + this.uploadPath, this.userName, this.password, md5);
        Request.Builder builder = new Request.Builder().url(this.url).header("Date", date).header(AUTHORIZATION, sign).header(X_UPYUN_MULTI_STAGE, "initiate").header(X_UPYUN_MULTI_TYPE, "application/octet-stream").header(X_UPYUN_MULTI_LENGTH, this.mFile.length() + "").header("User-Agent", "upyun-android-sdk 2.0.6").put(requestBody);
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                builder.header(entry.getKey(), entry.getValue());
            }
        }
        if (md5 != null) {
            builder.header(CONTENT_MD5, md5);
        }
        this.callRequest(builder.build());
        if (this.onProgressListener != null) {
            this.onProgressListener.onRequestProgress(1L, this.totalBlock);
        }
        return this.processUpload();
    }

    private boolean processUpload() throws IOException, UpYunException {
        byte[] data = new byte[]{};
        while (this.nextPartIndex >= 0) {
            data = this.readBlockByIndex(this.nextPartIndex);
            RequestBody requestBody = RequestBody.create(null, (byte[])data);
            String date = this.getGMTDate();
            String md5 = null;
            if (this.checkMD5) {
                md5 = UpYunUtils.md5(data);
            }
            String sign = this.sign("PUT", date, "/" + this.bucketName + this.uploadPath, this.userName, this.password, md5);
            Request.Builder builder = new Request.Builder().url(this.url).header("Date", date).header(AUTHORIZATION, sign).header(X_UPYUN_MULTI_STAGE, "upload").header(X_UPYUN_MULTI_UUID, this.uuid).header(X_UPYUN_PART_ID, this.nextPartIndex + "").header("User-Agent", "upyun-android-sdk 2.0.6").put(requestBody);
            if (md5 != null) {
                builder.header(CONTENT_MD5, md5);
            }
            if (this.onProgressListener != null) {
                this.onProgressListener.onRequestProgress(this.nextPartIndex + 2, this.totalBlock);
            }
            this.callRequest(builder.build());
        }
        return this.completeUpload();
    }

    private boolean completeUpload() throws IOException, UpYunException {
        RequestBody requestBody = RequestBody.create(null, (String)"");
        String date = this.getGMTDate();
        String md5 = null;
        if (this.checkMD5) {
            md5 = UpYunUtils.md5("");
        }
        String sign = this.sign("PUT", date, "/" + this.bucketName + this.uploadPath, this.userName, this.password, md5);
        Request.Builder builder = new Request.Builder().url(this.url).header("Date", date).header(AUTHORIZATION, sign).header(X_UPYUN_MULTI_STAGE, "complete").header(X_UPYUN_MULTI_UUID, this.uuid).header("User-Agent", "upyun-android-sdk 2.0.6").put(requestBody);
        if (md5 != null) {
            builder.header(CONTENT_MD5, md5);
        }
        this.callRequest(builder.build());
        if (this.onProgressListener != null) {
            this.onProgressListener.onRequestProgress(this.totalBlock, this.totalBlock);
        }
        this.uuid = null;
        return true;
    }

    private void callRequest(Request request) throws IOException, UpYunException {
        this.currentCall = this.mClient.newCall(request);
        Response response = this.currentCall.execute();
        if (!response.isSuccessful()) {
            int x_error_code = Integer.parseInt(response.header("X-Error-Code", "-1"));
            Log.e((String)"x_error_code", (String)("::" + x_error_code));
            if (x_error_code != 40011061 && x_error_code != 40011059) {
                this.uuid = null;
                throw new UpYunException(response.body().string());
            }
            this.nextPartIndex = Integer.parseInt(response.header(X_UPYUN_NEXT_PART_ID, "-2"));
            return;
        }
        this.uuid = response.header(X_UPYUN_MULTI_UUID, "");
        this.nextPartIndex = Integer.parseInt(response.header(X_UPYUN_NEXT_PART_ID, "-2"));
    }

    private String getGMTDate() {
        SimpleDateFormat formater = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        formater.setTimeZone(TimeZone.getTimeZone("GMT"));
        return formater.format(new Date());
    }

    private String sign(String method, String date, String path, String userName, String password, String md5) throws UpYunException {
        StringBuilder sb = new StringBuilder();
        String sp = "&";
        sb.append(method);
        sb.append(sp);
        sb.append(path);
        sb.append(sp);
        sb.append(date);
        if (md5 != null) {
            sb.append(sp);
            sb.append(md5);
        }
        String raw = sb.toString().trim();
        byte[] hmac = null;
        try {
            hmac = UpYunUtils.calculateRFC2104HMACRaw(password, raw);
        }
        catch (Exception e) {
            throw new UpYunException("calculate SHA1 wrong.");
        }
        if (hmac != null) {
            return "UPYUN " + userName + ":" + Base64Coder.encodeLines(hmac);
        }
        return null;
    }

    private byte[] readBlockByIndex(int index) throws IOException {
        byte[] block = new byte[0x100000];
        int readedSize = 0;
        int offset = index * 0x100000;
        this.randomAccessFile.seek(offset);
        readedSize = this.randomAccessFile.read(block, 0, 0x100000);
        if (readedSize < 0x100000) {
            byte[] notFullBlock = new byte[readedSize];
            System.arraycopy(block, 0, notFullBlock, 0, readedSize);
            return notFullBlock;
        }
        return block;
    }

    public class Params {
        public static final String BUCKET_NAME = "bucket_name";
        public static final String NOTIFY_URL = "notify_url";
        public static final String SOURCE = "source";
        public static final String TASKS = "tasks";
        public static final String ACCEPT = "accept";
        public static final String STATUS_CODE = "status_code";
        public static final String PATH = "path";
        public static final String DESCRIPTION = "description";
        public static final String TASK_ID = "task_id";
        public static final String INFO = "info";
        public static final String SIGNATURE = "signature";
        public static final String TIMESTAMP = "timestamp";
        public static final String TASK_IDS = "task_ids";
        public static final String TYPE = "type";
        public static final String SAVE_AS = "save_as";
        public static final String RETURN_INFO = "return_info";
        public static final String AVOPTS = "avopts";
    }

    public static interface OnInterruptListener {
        public void OnInterrupt(boolean var1);
    }
}

