/*
 * Decompiled with CFR 0.152.
 */
package demo;

import com.UpYun;
import com.upyun.RestManager;
import com.upyun.UpException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import okhttp3.Response;

public class RestManagerDemo {
    private static final String BUCKET_NAME = "\u7a7a\u95f4\u540d\u79f0";
    private static final String OPERATOR_NAME = "\u64cd\u4f5c\u5458\u540d\u79f0";
    private static final String OPERATOR_PWD = "\u64cd\u4f5c\u5458\u5bc6\u7801";
    private static final String DIR_ROOT = "/";
    private static final String DIR_MORE = "/1/2/3/";
    private static final String FOLDER_NAME = "tmp";
    private static final String FILE_NAME = "test.txt";
    private static final String SAMPLE_TXT_FILE = System.getProperty("user.dir") + "/test.txt";
    private static RestManager restManager = null;

    public static void main(String[] args) throws IOException, UpException {
        restManager = new RestManager(BUCKET_NAME, OPERATOR_NAME, OPERATOR_PWD);
        restManager.setApiDomain("https://v0.api.upyun.com");
        restManager.setTimeout(60);
        RestManagerDemo.testWriteFile();
        RestManagerDemo.testCopyFile();
        RestManagerDemo.testMoveFile();
        RestManagerDemo.testReadFile();
        RestManagerDemo.testDeleteFile();
        RestManagerDemo.testMkDir();
        RestManagerDemo.testRmDir();
        RestManagerDemo.testGetFileInfo();
        RestManagerDemo.testReadDir();
        RestManagerDemo.testGetBucketUsage();
    }

    public static void testGetBucketUsage() throws IOException, UpException {
        Response response = restManager.getBucketUsage();
        System.out.println("\u7a7a\u95f4\u603b\u4f7f\u7528\u91cf\uff1a" + response.body().string() + "B");
        System.out.println();
    }

    public static void testWriteFile() throws IOException, UpException {
        String content = "test content";
        String filePath = "/test.txt";
        String filePath2 = "/1/2/3/test.txt";
        String filePath3 = "/1/2/3/test3.txt";
        Response response = restManager.writeFile(filePath, content.getBytes(), null);
        System.out.println("1.\u4e0a\u4f20 " + filePath + RestManagerDemo.isSuccess(response));
        File file = new File(SAMPLE_TXT_FILE);
        Response response2 = restManager.writeFile(filePath2, file, null);
        System.out.println("2.\u4e0a\u4f20 " + filePath2 + RestManagerDemo.isSuccess(response2));
        File file2 = new File(SAMPLE_TXT_FILE);
        Response response3 = restManager.writeFile(filePath3, new FileInputStream(file2), null);
        System.out.println("3.\u4e0a\u4f20 " + filePath3 + RestManagerDemo.isSuccess(response3));
    }

    public static void testGetFileInfo() throws IOException, UpException {
        String filePath = "/1/2/3/test3.txt";
        System.out.println(filePath + " \u7684\u6587\u4ef6\u4fe1\u606f\uff1a" + restManager.getFileInfo(filePath).headers());
        System.out.println();
    }

    public static void testReadFile() throws IOException, UpException {
        String filePath = "/test.txt";
        Response response = restManager.readFile(filePath);
        System.out.println(filePath + " \u7684\u6587\u4ef6\u5185\u5bb9:" + response.body().string());
    }

    public static void testDeleteFile() throws IOException, UpException {
        String filePath = "/test.txt";
        Response response = restManager.deleteFile(filePath, null);
        System.out.println(filePath + " \u5220\u9664" + RestManagerDemo.isSuccess(response));
        System.out.println();
    }

    public static void testMkDir() throws IOException, UpException {
        String dir1 = "/tmp";
        Response response = restManager.mkDir(dir1);
        System.out.println("\u521b\u5efa\u76ee\u5f55\uff1a" + dir1 + RestManagerDemo.isSuccess(response));
    }

    public static void testRmDir() throws IOException, UpException {
        String dirPath = "/tmp";
        Response response = restManager.rmDir(dirPath);
        System.out.println("\u5220\u9664\u76ee\u5f55\uff1a" + dirPath + RestManagerDemo.isSuccess(response));
    }

    public static void testReadDir() throws IOException, UpException {
        String dirPath = DIR_ROOT;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(UpYun.PARAMS.KEY_X_LIST_LIMIT.getValue(), "10");
        Response response = restManager.readDirIter(dirPath, params);
        System.out.println(response.body().string());
    }

    public static void testCopyFile() throws IOException, UpException {
        String sourcePath = "/\u7a7a\u95f4\u540d\u79f0/test.txt";
        Response response = restManager.copyFile("/copy.txt", sourcePath, null);
        System.out.println("\u590d\u5236\u6587\u4ef6\uff1a" + sourcePath + RestManagerDemo.isSuccess(response));
    }

    public static void testMoveFile() throws IOException, UpException {
        String sourcePath = "/\u7a7a\u95f4\u540d\u79f0/1/2/3/test.txt";
        Response response = restManager.moveFile("/move.txt", sourcePath, null);
        System.out.println("\u79fb\u52a8\u6587\u4ef6\uff1a" + sourcePath + RestManagerDemo.isSuccess(response));
    }

    private static String isSuccess(Response response) {
        return response.isSuccessful() ? " \u6210\u529f" : " \u5931\u8d25";
    }

    static {
        File txtFile = new File(SAMPLE_TXT_FILE);
        if (!txtFile.isFile()) {
            System.out.println("\u672c\u5730\u5f85\u4e0a\u4f20\u7684\u6d4b\u8bd5\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
        }
    }
}

