/*
 * Decompiled with CFR 0.152.
 */
package com.upplication.s3fs;

import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import com.upplication.s3fs.S3Path;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.tika.Tika;

public class S3FileChannel
extends FileChannel {
    private S3Path path;
    private Set<? extends OpenOption> options;
    private FileChannel filechannel;
    private Path tempFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S3FileChannel(S3Path path, Set<? extends OpenOption> options) throws IOException {
        this.path = path;
        this.options = Collections.unmodifiableSet(new HashSet<OpenOption>(options));
        String key = path.getKey();
        boolean exists = path.getFileSystem().provider().exists(path);
        if (exists && this.options.contains(StandardOpenOption.CREATE_NEW)) {
            throw new FileAlreadyExistsException(String.format("target already exists: %s", path));
        }
        if (!(exists || this.options.contains(StandardOpenOption.CREATE_NEW) || this.options.contains(StandardOpenOption.CREATE))) {
            throw new NoSuchFileException(String.format("target not exists: %s", path));
        }
        this.tempFile = Files.createTempFile("temp-s3-", key.replaceAll("/", "_"), new FileAttribute[0]);
        boolean removeTempFile = true;
        try {
            if (exists) {
                try (S3Object object = path.getFileSystem().getClient().getObject(path.getFileStore().getBucket().getName(), key);){
                    Files.copy((InputStream)object.getObjectContent(), this.tempFile, StandardCopyOption.REPLACE_EXISTING);
                }
            }
            HashSet<? extends OpenOption> fileChannelOptions = new HashSet<OpenOption>(this.options);
            fileChannelOptions.remove(StandardOpenOption.CREATE_NEW);
            this.filechannel = FileChannel.open(this.tempFile, fileChannelOptions, new FileAttribute[0]);
            removeTempFile = false;
        }
        finally {
            if (removeTempFile) {
                Files.deleteIfExists(this.tempFile);
            }
        }
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this.filechannel.read(dst);
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        return this.filechannel.read(dsts, offset, length);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.filechannel.write(src);
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return this.filechannel.write(srcs, offset, length);
    }

    @Override
    public long position() throws IOException {
        return this.filechannel.position();
    }

    @Override
    public FileChannel position(long newPosition) throws IOException {
        return this.filechannel.position(newPosition);
    }

    @Override
    public long size() throws IOException {
        return this.filechannel.size();
    }

    @Override
    public FileChannel truncate(long size) throws IOException {
        return this.filechannel.truncate(size);
    }

    @Override
    public void force(boolean metaData) throws IOException {
        this.filechannel.force(metaData);
    }

    @Override
    public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
        return this.filechannel.transferTo(position, count, target);
    }

    @Override
    public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
        return this.filechannel.transferFrom(src, position, count);
    }

    @Override
    public int read(ByteBuffer dst, long position) throws IOException {
        return this.filechannel.read(dst, position);
    }

    @Override
    public int write(ByteBuffer src, long position) throws IOException {
        return this.filechannel.write(src, position);
    }

    @Override
    public MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) throws IOException {
        return this.filechannel.map(mode, position, size);
    }

    @Override
    public FileLock lock(long position, long size, boolean shared) throws IOException {
        return this.filechannel.lock(position, size, shared);
    }

    @Override
    public FileLock tryLock(long position, long size, boolean shared) throws IOException {
        return this.filechannel.tryLock(position, size, shared);
    }

    @Override
    protected void implCloseChannel() throws IOException {
        super.close();
        this.filechannel.close();
        if (!this.options.contains(StandardOpenOption.READ)) {
            this.sync();
        }
        Files.deleteIfExists(this.tempFile);
    }

    protected void sync() throws IOException {
        try (BufferedInputStream stream = new BufferedInputStream(Files.newInputStream(this.tempFile, new OpenOption[0]));){
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setContentLength(Files.size(this.tempFile));
            metadata.setContentType(new Tika().detect((InputStream)stream, this.path.getFileName().toString()));
            String bucket = this.path.getFileStore().name();
            String key = this.path.getKey();
            this.path.getFileSystem().getClient().putObject(bucket, key, (InputStream)stream, metadata);
        }
    }
}

