/*
 * Decompiled with CFR 0.152.
 */
package com.upplication.s3fs;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.upplication.s3fs.AmazonS3ClientFactory;
import com.upplication.s3fs.AmazonS3Factory;
import com.upplication.s3fs.S3AccessControlList;
import com.upplication.s3fs.S3FileSystem;
import com.upplication.s3fs.S3FileSystemConfigurationException;
import com.upplication.s3fs.S3Iterator;
import com.upplication.s3fs.S3Path;
import com.upplication.s3fs.S3SeekableByteChannel;
import com.upplication.s3fs.attribute.S3BasicFileAttributeView;
import com.upplication.s3fs.attribute.S3BasicFileAttributes;
import com.upplication.s3fs.attribute.S3PosixFileAttributeView;
import com.upplication.s3fs.attribute.S3PosixFileAttributes;
import com.upplication.s3fs.util.AttributesUtils;
import com.upplication.s3fs.util.Cache;
import com.upplication.s3fs.util.S3Utils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.spi.FileSystemProvider;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class S3FileSystemProvider
extends FileSystemProvider {
    public static final String CHARSET_KEY = "s3fs_charset";
    public static final String AMAZON_S3_FACTORY_CLASS = "s3fs_amazon_s3_factory";
    private static final ConcurrentMap<String, S3FileSystem> fileSystems = new ConcurrentHashMap<String, S3FileSystem>();
    private S3Utils s3Utils = new S3Utils();
    private Cache cache = new Cache();

    @Override
    public String getScheme() {
        return "s3";
    }

    @Override
    public FileSystem newFileSystem(URI uri, Map<String, ?> env) {
        this.validateUri(uri);
        Properties props = this.getProperties(uri, env);
        this.validateProperties(props);
        String key = this.getFileSystemKey(uri, props);
        if (fileSystems.containsKey(key)) {
            throw new FileSystemAlreadyExistsException("File system " + uri.getScheme() + ':' + key + " already exists");
        }
        S3FileSystem fileSystem = this.createFileSystem(uri, props);
        fileSystems.put(fileSystem.getKey(), fileSystem);
        return fileSystem;
    }

    private void validateProperties(Properties props) {
        Preconditions.checkArgument((props.getProperty("s3fs_access_key") == null && props.getProperty("s3fs_secret_key") == null || props.getProperty("s3fs_access_key") != null && props.getProperty("s3fs_secret_key") != null ? 1 : 0) != 0, (String)"%s and %s should both be provided or should both be omitted", (Object[])new Object[]{"s3fs_access_key", "s3fs_secret_key"});
    }

    private Properties getProperties(URI uri, Map<String, ?> env) {
        Properties props = this.loadAmazonProperties();
        this.overloadProperties(props, env);
        String userInfo = uri.getUserInfo();
        if (userInfo != null) {
            String[] keys = userInfo.split(":");
            props.setProperty("s3fs_access_key", keys[0]);
            if (keys.length > 1) {
                props.setProperty("s3fs_secret_key", keys[1]);
            }
        }
        return props;
    }

    private String getFileSystemKey(URI uri) {
        return this.getFileSystemKey(uri, this.getProperties(uri, null));
    }

    protected String getFileSystemKey(URI uri, Properties props) {
        String uriString = uri.toString().replace("s3://", "");
        String authority = null;
        int authoritySeparator = uriString.indexOf("@");
        if (authoritySeparator > 0) {
            authority = uriString.substring(0, authoritySeparator);
        }
        if (authority != null) {
            String host = uriString.substring(uriString.indexOf("@") + 1, uriString.length());
            int lastPath = host.indexOf("/");
            if (lastPath > -1) {
                host = host.substring(0, lastPath);
            }
            if (host.length() == 0) {
                host = "s3.amazonaws.com";
            }
            return authority + "@" + host;
        }
        String accessKey = (String)props.get("s3fs_access_key");
        return (accessKey != null ? accessKey + "@" : "") + (uri.getHost() != null ? uri.getHost() : "s3.amazonaws.com");
    }

    protected void validateUri(URI uri) {
        Preconditions.checkNotNull((Object)uri, (Object)"uri is null");
        Preconditions.checkArgument((boolean)uri.getScheme().equals(this.getScheme()), (String)"uri scheme must be 's3': '%s'", (Object[])new Object[]{uri});
    }

    protected void overloadProperties(Properties props, Map<String, ?> env) {
        if (env == null) {
            env = new HashMap();
        }
        for (String key : new String[]{"s3fs_access_key", "s3fs_secret_key", "s3fs_request_metric_collector_class", "s3fs_connection_timeout", "s3fs_max_connections", "s3fs_max_retry_error", "s3fs_protocol", "s3fs_proxy_domain", "s3fs_proxy_host", "s3fs_proxy_password", "s3fs_proxy_port", "s3fs_proxy_username", "s3fs_proxy_workstation", "s3fs_socket_send_buffer_size_hint", "s3fs_socket_receive_buffer_size_hint", "s3fs_socket_timeout", "s3fs_user_agent", AMAZON_S3_FACTORY_CLASS}) {
            this.overloadProperty(props, env, key);
        }
    }

    private void overloadProperty(Properties props, Map<String, ?> env, String key) {
        boolean overloaded = this.overloadPropertiesWithEnv(props, env, key);
        if (!overloaded) {
            overloaded = this.overloadPropertiesWithSystemProps(props, key);
        }
        if (!overloaded) {
            this.overloadPropertiesWithSystemEnv(props, key);
        }
    }

    protected boolean overloadPropertiesWithEnv(Properties props, Map<String, ?> env, String key) {
        if (env.get(key) != null && env.get(key) instanceof String) {
            props.setProperty(key, (String)env.get(key));
            return true;
        }
        return false;
    }

    public boolean overloadPropertiesWithSystemProps(Properties props, String key) {
        if (System.getProperty(key) != null) {
            props.setProperty(key, System.getProperty(key));
            return true;
        }
        return false;
    }

    public boolean overloadPropertiesWithSystemEnv(Properties props, String key) {
        if (this.systemGetEnv(key) != null) {
            props.setProperty(key, this.systemGetEnv(key));
            return true;
        }
        return false;
    }

    public String systemGetEnv(String key) {
        return System.getenv(key);
    }

    public FileSystem getFileSystem(URI uri, Map<String, ?> env) {
        this.validateUri(uri);
        Properties props = this.getProperties(uri, env);
        String key = this.getFileSystemKey(uri, props);
        if (fileSystems.containsKey(key)) {
            return (FileSystem)fileSystems.get(key);
        }
        return this.newFileSystem(uri, env);
    }

    @Override
    public S3FileSystem getFileSystem(URI uri) {
        this.validateUri(uri);
        String key = this.getFileSystemKey(uri);
        if (fileSystems.containsKey(key)) {
            return (S3FileSystem)fileSystems.get(key);
        }
        throw new FileSystemNotFoundException("S3 filesystem not yet created. Use newFileSystem() instead");
    }

    private S3Path toS3Path(Path path) {
        Preconditions.checkArgument((boolean)(path instanceof S3Path), (String)"path must be an instance of %s", (Object[])new Object[]{S3Path.class.getName()});
        return (S3Path)path;
    }

    @Override
    public Path getPath(URI uri) {
        S3FileSystem fileSystem = this.getFileSystem(uri);
        return ((FileSystem)fileSystem).getPath(uri.getPath(), new String[0]);
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        final S3Path s3Path = this.toS3Path(dir);
        return new DirectoryStream<Path>(){

            @Override
            public void close() throws IOException {
            }

            @Override
            public Iterator<Path> iterator() {
                return new S3Iterator(s3Path);
            }
        };
    }

    @Override
    public InputStream newInputStream(Path path, OpenOption ... options) throws IOException {
        S3Path s3Path = this.toS3Path(path);
        String key = s3Path.getKey();
        Preconditions.checkArgument((options.length == 0 ? 1 : 0) != 0, (String)"OpenOptions not yet supported: %s", (Object[])new Object[]{ImmutableList.copyOf((Object[])options)});
        Preconditions.checkArgument((!key.equals("") ? 1 : 0) != 0, (String)"cannot create InputStream for root directory: %s", (Object[])new Object[]{path});
        try {
            S3Object object = s3Path.getFileSystem().getClient().getObject(s3Path.getFileStore().name(), key);
            S3ObjectInputStream res = object.getObjectContent();
            if (res == null) {
                throw new IOException(String.format("The specified path is a directory: %s", path));
            }
            return res;
        }
        catch (AmazonS3Exception e) {
            if (e.getStatusCode() == 404) {
                throw new NoSuchFileException(path.toString());
            }
            throw new IOException(String.format("Cannot access file: %s", path), e);
        }
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        S3Path s3Path = this.toS3Path(path);
        return new S3SeekableByteChannel(s3Path, options);
    }

    @Override
    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        S3Path s3Path = this.toS3Path(dir);
        Preconditions.checkArgument((attrs.length == 0 ? 1 : 0) != 0, (String)"attrs not yet supported: %s", (Object[])new Object[]{ImmutableList.copyOf((Object[])attrs)});
        if (this.exists(s3Path)) {
            throw new FileAlreadyExistsException(String.format("target already exists: %s", s3Path));
        }
        Bucket bucket = s3Path.getFileStore().getBucket();
        String bucketName = s3Path.getFileStore().name();
        if (bucket == null) {
            s3Path.getFileSystem().getClient().createBucket(bucketName);
        }
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentLength(0L);
        s3Path.getFileSystem().getClient().putObject(bucketName, s3Path.getKey() + "/", (InputStream)new ByteArrayInputStream(new byte[0]), metadata);
    }

    @Override
    public void delete(Path path) throws IOException {
        S3Path s3Path = this.toS3Path(path);
        if (Files.notExists(s3Path, new LinkOption[0])) {
            throw new NoSuchFileException("the path: " + this + " not exists");
        }
        if (Files.isDirectory(s3Path, new LinkOption[0]) && Files.newDirectoryStream(s3Path).iterator().hasNext()) {
            throw new DirectoryNotEmptyException("the path: " + this + " is a directory and is not empty");
        }
        String key = s3Path.getKey();
        String bucketName = s3Path.getFileStore().name();
        s3Path.getFileSystem().getClient().deleteObject(bucketName, key);
        s3Path.getFileSystem().getClient().deleteObject(bucketName, key + "/");
    }

    @Override
    public void copy(Path source, Path target, CopyOption ... options) throws IOException {
        if (this.isSameFile(source, target)) {
            return;
        }
        S3Path s3Source = this.toS3Path(source);
        S3Path s3Target = this.toS3Path(target);
        Preconditions.checkArgument((!Files.isDirectory(source, new LinkOption[0]) ? 1 : 0) != 0, (String)"copying directories is not yet supported: %s", (Object[])new Object[]{source});
        Preconditions.checkArgument((!Files.isDirectory(target, new LinkOption[0]) ? 1 : 0) != 0, (String)"copying directories is not yet supported: %s", (Object[])new Object[]{target});
        ImmutableSet actualOptions = ImmutableSet.copyOf((Object[])options);
        this.verifySupportedOptions((Set)EnumSet.of(StandardCopyOption.REPLACE_EXISTING), (Set)actualOptions);
        if (this.exists(s3Target) && !actualOptions.contains((Object)StandardCopyOption.REPLACE_EXISTING)) {
            throw new FileAlreadyExistsException(String.format("target already exists: %s", target));
        }
        String bucketNameOrigin = s3Source.getFileStore().name();
        String keySource = s3Source.getKey();
        String bucketNameTarget = s3Target.getFileStore().name();
        String keyTarget = s3Target.getKey();
        s3Source.getFileSystem().getClient().copyObject(bucketNameOrigin, keySource, bucketNameTarget, keyTarget);
    }

    @Override
    public void move(Path source, Path target, CopyOption ... options) throws IOException {
        if (options != null && Arrays.asList(options).contains(StandardCopyOption.ATOMIC_MOVE)) {
            throw new AtomicMoveNotSupportedException(source.toString(), target.toString(), "Atomic not supported");
        }
        this.copy(source, target, options);
        this.delete(source);
    }

    @Override
    public boolean isSameFile(Path path1, Path path2) throws IOException {
        return path1.isAbsolute() && path2.isAbsolute() && path1.equals(path2);
    }

    @Override
    public boolean isHidden(Path path) throws IOException {
        return false;
    }

    @Override
    public FileStore getFileStore(Path path) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void checkAccess(Path path, AccessMode ... modes) throws IOException {
        S3Path s3Path = this.toS3Path(path);
        Preconditions.checkArgument((boolean)s3Path.isAbsolute(), (String)"path must be absolute: %s", (Object[])new Object[]{s3Path});
        if (modes.length == 0) {
            if (this.exists(s3Path)) {
                return;
            }
            throw new NoSuchFileException(this.toString());
        }
        String key = this.s3Utils.getS3ObjectSummary(s3Path).getKey();
        S3AccessControlList accessControlList = new S3AccessControlList(s3Path.getFileStore().name(), key, s3Path.getFileSystem().getClient().getObjectAcl(s3Path.getFileStore().name(), key), s3Path.getFileStore().getOwner());
        accessControlList.checkAccess(modes);
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
        S3Path s3Path = this.toS3Path(path);
        if (type == BasicFileAttributeView.class) {
            return (V)new S3BasicFileAttributeView(s3Path);
        }
        if (type == PosixFileAttributeView.class) {
            return (V)new S3PosixFileAttributeView(s3Path);
        }
        if (type == null) {
            throw new NullPointerException("Type is mandatory");
        }
        return null;
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
        S3Path s3Path = this.toS3Path(path);
        if (type == BasicFileAttributes.class) {
            if (this.cache.isInTime(s3Path.getFileSystem().getCache(), s3Path.getFileAttributes())) {
                BasicFileAttributes result = (BasicFileAttributes)type.cast(s3Path.getFileAttributes());
                s3Path.setFileAttributes(null);
                return (A)result;
            }
            S3BasicFileAttributes attrs = this.s3Utils.getS3FileAttributes(s3Path);
            s3Path.setFileAttributes(attrs);
            return (A)((BasicFileAttributes)type.cast(attrs));
        }
        if (type == PosixFileAttributes.class) {
            if (s3Path.getFileAttributes() instanceof PosixFileAttributes && this.cache.isInTime(s3Path.getFileSystem().getCache(), s3Path.getFileAttributes())) {
                BasicFileAttributes result = (BasicFileAttributes)type.cast(s3Path.getFileAttributes());
                s3Path.setFileAttributes(null);
                return (A)result;
            }
            S3PosixFileAttributes attrs = this.s3Utils.getS3PosixFileAttributes(s3Path);
            s3Path.setFileAttributes(attrs);
            return (A)((BasicFileAttributes)type.cast(attrs));
        }
        throw new UnsupportedOperationException(String.format("only %s or %s supported", BasicFileAttributes.class, PosixFileAttributes.class));
    }

    @Override
    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
        if (attributes == null) {
            throw new IllegalArgumentException("Attributes null");
        }
        if (attributes.contains(":") && !attributes.contains("basic:") && !attributes.contains("posix:")) {
            throw new UnsupportedOperationException(String.format("attributes %s are not supported, only basic / posix are supported", attributes));
        }
        if (attributes.equals("*") || attributes.equals("basic:*")) {
            BasicFileAttributes attr = this.readAttributes(path, BasicFileAttributes.class, options);
            return AttributesUtils.fileAttributeToMap(attr);
        }
        if (attributes.equals("posix:*")) {
            PosixFileAttributes attr = this.readAttributes(path, PosixFileAttributes.class, options);
            return AttributesUtils.fileAttributeToMap(attr);
        }
        String[] filters = new String[]{attributes};
        if (attributes.contains(",")) {
            filters = attributes.split(",");
        }
        Class<BasicFileAttributes> filter = BasicFileAttributes.class;
        if (attributes.startsWith("posix:")) {
            filter = PosixFileAttributes.class;
        }
        return AttributesUtils.fileAttributeToMap(this.readAttributes(path, filter, options), filters);
    }

    @Override
    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
        throw new UnsupportedOperationException();
    }

    public S3FileSystem createFileSystem(URI uri, Properties props) {
        return new S3FileSystem(this, this.getFileSystemKey(uri, props), this.getAmazonS3(uri, props), uri.getHost());
    }

    protected AmazonS3 getAmazonS3(URI uri, Properties props) {
        return this.getAmazonS3Factory(props).getAmazonS3(uri, props);
    }

    protected AmazonS3Factory getAmazonS3Factory(Properties props) {
        if (props.containsKey(AMAZON_S3_FACTORY_CLASS)) {
            String amazonS3FactoryClass = props.getProperty(AMAZON_S3_FACTORY_CLASS);
            try {
                return (AmazonS3Factory)Class.forName(amazonS3FactoryClass).newInstance();
            }
            catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new S3FileSystemConfigurationException("Configuration problem, couldn't instantiate AmazonS3Factory (" + amazonS3FactoryClass + "): ", e);
            }
        }
        return new AmazonS3ClientFactory();
    }

    public Properties loadAmazonProperties() {
        Properties props = new Properties();
        try (InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("amazon.properties");){
            if (in != null) {
                props.load(in);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return props;
    }

    private <T> void verifySupportedOptions(Set<? extends T> allowedOptions, Set<? extends T> actualOptions) {
        Sets.SetView unsupported = Sets.difference(actualOptions, allowedOptions);
        Preconditions.checkArgument((boolean)unsupported.isEmpty(), (String)"the following options are not supported: %s", (Object[])new Object[]{unsupported});
    }

    boolean exists(S3Path path) {
        S3Path s3Path = this.toS3Path(path);
        try {
            this.s3Utils.getS3ObjectSummary(s3Path);
            return true;
        }
        catch (NoSuchFileException e) {
            return false;
        }
    }

    public void close(S3FileSystem fileSystem) {
        if (fileSystem.getKey() != null && fileSystems.containsKey(fileSystem.getKey())) {
            fileSystems.remove(fileSystem.getKey());
        }
    }

    public boolean isOpen(S3FileSystem s3FileSystem) {
        return fileSystems.containsKey(s3FileSystem.getKey());
    }

    protected static ConcurrentMap<String, S3FileSystem> getFilesystems() {
        return fileSystems;
    }

    public Cache getCache() {
        return this.cache;
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }
}

